/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.service;

import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DNSServerService {
    private static final Logger log = LoggerFactory.getLogger(DNSServerService.class);
    @Autowired
    protected DNSStore dnsStore;
    @Autowired
    protected DNSServerSettings settings;
    protected DNSServer server;

    public void startServer() throws DNSException {
        log.info("Creating the DNSServer");
        this.server = new DNSServer(this.dnsStore, this.settings);
        log.info("DNS Server created.  Starting server.");
        this.server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    log.info("Shutdown hook detected.  Intiate server shutdown.");
                    DNSServerService.this.stopService();
                }
                catch (DNSException dNSException) {
                    // empty catch block
                }
            }
        });
    }

    public synchronized void stopService() throws DNSException {
        if (this.server != null) {
            log.info("Shutting down DNS server.");
            this.server.stop();
        }
    }
}

