/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.springconfig;

import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.service.DNSServerService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DNSServerConfig {
    @Value(value="${direct.dns.binding.port:53}")
    protected int port;
    @Value(value="${direct.dns.binding.address:0.0.0.0}")
    protected String bindAddress;
    @Value(value="${direct.dns.binding.maxReconnectAttempts:10}")
    protected int maxReconnectAttempts;

    @Bean
    @ConditionalOnMissingBean
    public DNSServerSettings dnsServerSettings() {
        DNSServerSettings settings = new DNSServerSettings();
        settings.setBindAddress(this.bindAddress);
        settings.setPort(this.port);
        settings.setMaxReconnectAttempts(this.maxReconnectAttempts);
        return settings;
    }

    @Bean(destroyMethod="stopService")
    @ConditionalOnMissingBean
    public DNSServerService dnsServerService() {
        return new DNSServerService();
    }
}

