/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.nhindirect.dns.tools.StopabbleLoopedJob;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;

@EnableAutoConfiguration(exclude={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
public class DNSLoadTester
implements CommandLineRunner {
    protected static final int DEFAULT_NUM_CERT_THREADS = 20;
    protected static final int DEFAULT_NUM_MX_THREADS = 20;
    protected String dnsServerTarget;
    protected String targetDomain;
    protected int numCertLookupThreads = 20;
    protected int numMXLookupThreads = 20;
    protected DNSLookupJob[] certLookupThreads;
    protected DNSLookupJob[] mxLookupThreads;
    protected long startTime;

    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{DNSLoadTester.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        app.run(args);
    }

    public void run(String ... args) {
        Thread thread;
        int i;
        for (i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                System.err.println("Error: Unexpected argument [" + arg + "]\n");
                DNSLoadTester.printUsage();
                System.exit(-1);
                continue;
            }
            if (arg.equalsIgnoreCase("-server")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing DNS server");
                    System.exit(-1);
                }
                this.dnsServerTarget = args[++i];
                continue;
            }
            if (arg.equals("-domain")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing domain");
                    System.exit(-1);
                }
                this.targetDomain = args[++i];
                continue;
            }
            if (arg.equals("-numCertLookups")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing number of certificate lookup threads");
                    System.exit(-1);
                }
                this.numCertLookupThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (arg.equals("-numMXLookups")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing number of MX lookup threads");
                    System.exit(-1);
                }
                this.numMXLookupThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (arg.equals("-help")) {
                DNSLoadTester.printUsage();
                System.exit(-1);
                continue;
            }
            System.err.println("Error: Unknown argument " + arg + "\n");
            DNSLoadTester.printUsage();
            System.exit(-1);
        }
        if (StringUtils.isEmpty((CharSequence)this.dnsServerTarget)) {
            System.err.println("You must provide a target DNS server.");
            DNSLoadTester.printUsage();
            System.exit(-1);
        }
        if (StringUtils.isEmpty((CharSequence)this.targetDomain)) {
            System.err.println("You must provide a target domain to query.");
            DNSLoadTester.printUsage();
            System.exit(-1);
        }
        this.startTime = System.currentTimeMillis();
        this.certLookupThreads = new DNSLookupJob[this.numCertLookupThreads];
        for (i = 0; i < this.numCertLookupThreads; ++i) {
            this.certLookupThreads[i] = new DNSLookupJob(37, true);
            thread = new Thread(this.certLookupThreads[i]);
            thread.setDaemon(true);
            thread.start();
        }
        this.mxLookupThreads = new DNSLookupJob[this.numMXLookupThreads];
        for (i = 0; i < this.numCertLookupThreads; ++i) {
            this.mxLookupThreads[i] = new DNSLookupJob(15, false);
            thread = new Thread(this.mxLookupThreads[i]);
            thread.setDaemon(true);
            thread.start();
        }
        String command = "";
        System.out.println("DNS queries running.");
        System.out.println("\tTarget DNS server: " + this.dnsServerTarget);
        System.out.println("\tTarget DNS domain: " + this.targetDomain);
        System.out.println("\t" + this.numCertLookupThreads + " certificate lookup threads running.");
        System.out.println("\t" + this.numCertLookupThreads + " MX lookup threads running.");
        Scanner scanner = new Scanner(System.in);
        while (command.compareToIgnoreCase("QUIT") != 0) {
            System.out.print("\r\n>");
            command = scanner.nextLine();
            if (command.compareToIgnoreCase("AVERAGE") != 0) continue;
            this.computeRunningAverage();
        }
        System.out.println("\r\nShutting down DNS running queries.\r\n");
        scanner.close();
        for (DNSLookupJob job : this.certLookupThreads) {
            job.setRunning(false);
        }
        for (DNSLookupJob job : this.mxLookupThreads) {
            job.setRunning(false);
        }
        this.computeRunningAverage();
    }

    protected ExtendedResolver createExResolver(String[] servers, int retries, int timeout, boolean useTCP) {
        ExtendedResolver extendedResolver = new ExtendedResolver();
        Object[] resolvers = extendedResolver.getResolvers();
        if (!ArrayUtils.isEmpty((Object[])resolvers)) {
            for (Object object : resolvers) {
                extendedResolver.deleteResolver((Resolver)object);
            }
        }
        if (!ArrayUtils.isEmpty((Object[])servers)) {
            for (String string : servers) {
                String string2 = string.replaceFirst("\\.$", "");
                try {
                    SimpleResolver simpleResolver = new SimpleResolver(string2);
                    extendedResolver.addResolver((Resolver)simpleResolver);
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            extendedResolver.setRetries(retries);
            extendedResolver.setTimeout(Duration.ofSeconds(timeout));
            extendedResolver.setTCP(useTCP);
        }
        return extendedResolver;
    }

    protected void computeRunningAverage() {
        long totalCERTQueries = 0L;
        long totalMXQueries = 0L;
        long totalFailedMXQueires = 0L;
        long totalFailedCERTQueires = 0L;
        for (DNSLookupJob job : this.certLookupThreads) {
            totalCERTQueries += job.getNumQueries();
            totalFailedCERTQueires += job.getNumFailedQueries();
        }
        for (DNSLookupJob job : this.mxLookupThreads) {
            totalMXQueries += job.getNumQueries();
            totalFailedMXQueires += job.getNumFailedQueries();
        }
        long totalQueries = totalCERTQueries + totalMXQueries;
        long elapsedTimeInSeconds = (System.currentTimeMillis() - this.startTime) / 1000L;
        long avg = totalQueries / elapsedTimeInSeconds;
        System.out.println("Average queires per second: " + avg);
        System.out.println("\tTotal queires: " + totalQueries);
        System.out.println("\t\tMX queires: " + totalMXQueries);
        System.out.println("\t\tCERT queires: " + totalCERTQueries);
        System.out.println("\r\n\tTotal MX failed queires: " + totalFailedMXQueires);
        System.out.println("\tTotal CERT failed queires: " + totalFailedCERTQueires);
    }

    private static void printUsage() {
        StringBuffer use = new StringBuffer();
        use.append("Usage:\n");
        use.append("DNSLoadTester (options)...\n\n");
        use.append("options:\n");
        use.append("-server server          The target DNS server to load test.\n");
        use.append("\n");
        use.append("-domain domain          A valid domain that should create successful DNS lookups\n");
        use.append("\n");
        use.append("-numCertLookups threads Number of thread to perform certificate lookups.\n");
        use.append("\n");
        use.append("-numMXLookups threads   Number of thread to perform MX lookups.\n");
        System.err.println(use);
    }

    protected class DNSLookupJob
    extends StopabbleLoopedJob {
        protected Lookup lu;
        protected AtomicLong numQueries = new AtomicLong();
        protected AtomicLong failedQuries = new AtomicLong();

        public DNSLookupJob(int lookupType, boolean useTCP) {
            try {
                this.lu = new Lookup(new Name(DNSLoadTester.this.targetDomain), lookupType);
                String[] server = new String[]{DNSLoadTester.this.dnsServerTarget};
                this.lu.setResolver((Resolver)DNSLoadTester.this.createExResolver(server, 3, 2, useTCP));
                this.lu.setSearchPath((String[])null);
            }
            catch (Exception e) {
                this.setRunning(false);
            }
        }

        @Override
        public void executeJob() {
            this.numQueries.getAndIncrement();
            this.lu.setCache(new Cache(1));
            Record[] retRecords = this.lu.run();
            if (retRecords == null || retRecords.length <= 0) {
                this.failedQuries.getAndIncrement();
            }
        }

        public long getNumQueries() {
            return this.numQueries.get();
        }

        public long getNumFailedQueries() {
            return this.failedQuries.get();
        }
    }
}

