/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.routing.impl;

import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhind.config.Address;
import org.nhind.config.ConfigurationServiceException;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.EntityStatus;
import org.nhindirect.xd.routing.RoutingResolver;
import org.nhindirect.xd.routing.exception.ResolverException;

public class RoutingResolverImpl
extends RoutingResolver {
    private ConfigurationServiceProxy proxy;
    private static final Log LOGGER = LogFactory.getFactory().getInstance(RoutingResolverImpl.class);

    public RoutingResolverImpl() {
    }

    public RoutingResolverImpl(String configServiceUrl) {
        if (StringUtils.isNotBlank((String)configServiceUrl)) {
            this.proxy = new ConfigurationServiceProxy(configServiceUrl);
        }
    }

    @Override
    public String resolve(String address) {
        Address addr = this.lookup(address);
        if (addr != null) {
            if (StringUtils.isNotBlank((String)addr.getEndpoint())) {
                return addr.getEndpoint();
            }
            return addr.getEmailAddress();
        }
        return address;
    }

    @Override
    public boolean isSmtpEndpoint(String address) {
        if (address == null) {
            return false;
        }
        Address addr = this.lookup(address);
        if (addr != null && StringUtils.isNotBlank((String)addr.getType())) {
            return StringUtils.equalsIgnoreCase((String)addr.getType(), (String)"SMTP");
        }
        return StringUtils.contains((String)address, (char)'@');
    }

    @Override
    public boolean isXdEndpoint(String address) {
        if (address == null) {
            return false;
        }
        Address addr = this.lookup(address);
        if (addr != null && StringUtils.isNotBlank((String)addr.getType())) {
            return StringUtils.equalsIgnoreCase((String)addr.getType(), (String)"XD");
        }
        return !StringUtils.contains((String)address, (char)'@');
    }

    private Address lookup(String address) {
        block7: {
            if (this.proxy == null) {
                LOGGER.warn((Object)"Attempt to lookup address with unititialized configuration service, falling back to default routing.");
                return null;
            }
            try {
                Address[] addr = this.proxy.getAddresss(new String[]{address}, EntityStatus.ENABLED);
                if (addr == null || addr.length == 0) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Unable to find address " + address + " in configuration store."));
                    }
                    return null;
                }
                return addr[0];
            }
            catch (ConfigurationServiceException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)new ResolverException("Unable to look up address, falling back to default routing.", e));
                }
            }
            catch (RemoteException e) {
                if (!LOGGER.isWarnEnabled()) break block7;
                LOGGER.warn((Object)new ResolverException("Unable to look up address, falling back to default routing.", e));
            }
        }
        return null;
    }
}

