/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.xd.common.DirectDocument2;
import org.nhindirect.xd.common.DirectDocuments;
import org.nhindirect.xd.transform.util.type.MimeType;

public class XdmPackage {
    private String messageId;
    private DirectDocuments documents;
    @Deprecated
    private static final String SUFFIX = ".xml";
    private static final int BUFFER = 2048;
    private static final String XDM_SUB_FOLDER = "SUBSET01/";
    private static final String XDM_METADATA_FILE = "METADATA.xml";
    private static final Log LOGGER = LogFactory.getFactory().getInstance(XdmPackage.class);

    public XdmPackage() {
        this(UUID.randomUUID().toString());
    }

    public XdmPackage(String messageId) {
        this.messageId = messageId;
        this.documents = new DirectDocuments();
    }

    public void setDocuments(DirectDocuments documents) {
        this.documents = documents;
    }

    public DirectDocuments getDocuments() {
        return this.documents;
    }

    public File toFile() {
        File xdmFile = null;
        try {
            xdmFile = new File(this.messageId + "-xdm.zip");
            FileOutputStream dest = new FileOutputStream(xdmFile);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(dest));
            zipOutputStream.setMethod(8);
            for (DirectDocument2 document : this.documents.getDocuments()) {
                if (document.getData() == null) continue;
                this.addEntry(zipOutputStream, document.getData(), XDM_SUB_FOLDER + document.getMetadata().getId() + this.getSuffix(document.getMetadata().getMimeType()));
            }
            this.addEntry(zipOutputStream, this.documents.getSubmitObjectsRequestAsString().getBytes(), "SUBSET01/METADATA.xml");
            this.addEntry(zipOutputStream, this.getIndex().getBytes(), "INDEX.htm");
            this.addEntry(zipOutputStream, this.getReadme().getBytes(), "README.txt");
            if (SUFFIX.equals(SUFFIX)) {
                this.addEntry(zipOutputStream, this.getXsl().getBytes(), "SUBSET01/CCD.xsl");
            }
            zipOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xdmFile;
    }

    private void addEntry(ZipOutputStream zipOutputStream, byte[] data, String fileName) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        BufferedInputStream outputStream = new BufferedInputStream(inputStream);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOutputStream.putNextEntry(zipEntry);
        int count = 0;
        byte[] dataOut = new byte[2048];
        while ((count = outputStream.read(dataOut, 0, 2048)) != -1) {
            zipOutputStream.write(dataOut, 0, count);
        }
    }

    public String getIndex() throws Exception {
        String data;
        try {
            byte[] bytes = this.readFile("INDEX_head.txt");
            data = new String(bytes);
            for (DirectDocument2 document : this.documents.getDocuments()) {
                if (document.getData() == null) continue;
                String file = XDM_SUB_FOLDER + document.getMetadata().getId() + this.getSuffix(document.getMetadata().getMimeType());
                data = data + "<li><a href=\"" + file + "\">" + file + "</a> - " + document.getMetadata().getDescription() + "</li>";
            }
            bytes = this.readFile("INDEX_tail.txt");
            data = data + new String(bytes);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to access index file.", (Throwable)e);
            throw e;
        }
        return data;
    }

    public String getReadme() throws Exception {
        byte[] bytes;
        try {
            bytes = this.readFile("README.txt");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to access readme file.", (Throwable)e);
            throw e;
        }
        return new String(bytes);
    }

    public String getXsl() throws Exception {
        byte[] bytes;
        try {
            bytes = this.readFile("CCD.xsl");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to access xsl file.", (Throwable)e);
            throw e;
        }
        return new String(bytes);
    }

    public static XdmPackage fromXdmZipDataHandler(DataHandler dataHandler) throws Exception {
        File file = null;
        try {
            file = XdmPackage.fileFromDataHandler(dataHandler);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Error creating temporary work file, unable to complete transformation.", (Throwable)e);
            }
            throw new Exception("Error creating temporary work file, unable to complete transformation.", e);
        }
        XdmPackage xdmPackage = XdmPackage.fromXdmZipFile(file);
        boolean delete = file.delete();
        if (delete) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Deleted temporary work file " + file.getAbsolutePath()));
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn((Object)("Unable to delete temporary work file " + file.getAbsolutePath()));
        }
        return xdmPackage;
    }

    public static XdmPackage fromXdmZipFile(File file) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream;
        String subsetDirspec;
        String zname;
        DirectDocuments documents = new DirectDocuments();
        ZipFile zipFile = new ZipFile(file, 1);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        ZipEntry zipEntry = null;
        while (zipEntries.hasMoreElements()) {
            zipEntry = zipEntries.nextElement();
            zname = zipEntry.getName();
            LOGGER.info((Object)("Processing a ZipEntry named " + zname));
            if (zipEntry.isDirectory() || !XdmPackage.matchName(zname, subsetDirspec = XdmPackage.getSubmissionSetDirspec(zipEntry.getName()), XDM_METADATA_FILE)) continue;
            byteArrayOutputStream = XdmPackage.readData(zipFile, zipEntry);
            documents.setValues(byteArrayOutputStream.toString());
        }
        zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            LOGGER.trace((Object)"Processing a ZipEntry");
            zipEntry = zipEntries.nextElement();
            zname = zipEntry.getName();
            if (zipEntry.isDirectory() || !StringUtils.contains((String)(subsetDirspec = XdmPackage.getSubmissionSetDirspec(zipEntry.getName())), (String)StringUtils.remove((String)XDM_SUB_FOLDER, (String)"/")) || StringUtils.contains((String)zname, (String)".xsl") || StringUtils.contains((String)zname, (String)XDM_METADATA_FILE)) continue;
            byteArrayOutputStream = XdmPackage.readData(zipFile, zipEntry);
            String digest = DirectDocument2.getSha1Hash(byteArrayOutputStream.toString());
            System.out.println(digest);
            DirectDocument2 document = documents.getDocumentByHash(digest);
            if (document == null) {
                LOGGER.warn((Object)"Unable to find metadata for document by hash. Creating document with no supporting metadata.");
                document = new DirectDocument2();
                documents.getDocuments().add(document);
            }
            document.setData(byteArrayOutputStream.toByteArray());
        }
        zipFile.close();
        XdmPackage xdmPackage = new XdmPackage();
        xdmPackage.setDocuments(documents);
        return xdmPackage;
    }

    private static String getSubmissionSetDirspec(String zipEntryName) {
        if (zipEntryName == null) {
            return null;
        }
        String[] components = StringUtils.split((String)zipEntryName, (String)"\\/");
        return components[0];
    }

    private static boolean matchName(String zname, String subsetDirspec, String subsetFilespec) {
        String zipFilespec = subsetDirspec + "\\" + subsetFilespec.replace('/', '\\');
        boolean ret = StringUtils.equalsIgnoreCase((String)zname, (String)zipFilespec);
        if (!ret) {
            zipFilespec = zipFilespec.replace('\\', '/');
            ret = StringUtils.equalsIgnoreCase((String)zname, (String)zipFilespec);
        }
        return ret;
    }

    private static ByteArrayOutputStream readData(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        InputStream in = zipFile.getInputStream(zipEntry);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int bytesRead = 0;
        byte[] buffer = new byte[2048];
        while ((bytesRead = in.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        in.close();
        return baos;
    }

    private byte[] readFile(String filename) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(filename);
        byte[] bytes = new byte[is.available()];
        is.read(bytes);
        is.close();
        return bytes;
    }

    private static File fileFromDataHandler(DataHandler dh) throws Exception {
        File f = null;
        OutputStream out = null;
        InputStream inputStream = null;
        String fileName = UUID.randomUUID().toString() + ".zip";
        try {
            int len;
            f = new File(fileName);
            inputStream = dh.getInputStream();
            out = new FileOutputStream(f);
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("File not found - " + fileName), (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Exception thrown while trying to read file from DataHandler object", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (out != null) {
                out.close();
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Created temporary work file " + f.getAbsolutePath()));
        }
        return f;
    }

    private String getSuffix(String mimeType) {
        return "." + MimeType.lookup(mimeType).getSuffix();
    }
}

