/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.soap;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.xd.soap.ThreadData;
import org.nhindirect.xd.soap.type.MetadataLevelEnum;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DirectSOAPHandler
implements SOAPHandler<SOAPMessageContext> {
    protected String endpoint;
    protected String messageId;
    protected String relatesTo;
    protected String action;
    protected String to;
    protected String remoteHost;
    protected String thisHost;
    protected String pid;
    protected String from;
    protected String directFrom;
    protected String directTo;
    protected String directMetadataLevel;
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DirectSOAPHandler.class);

    @PostConstruct
    public void init() {
    }

    public void close(MessageContext messageContext) {
    }

    @PreDestroy
    public void destroy() {
    }

    public boolean handleMessage(SOAPMessageContext context) {
        block23: {
            LOGGER.info((Object)"Entering DirectSOAPHandler.handleMessage(SOAPMessageContext)");
            boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
            try {
                if (outbound) {
                    QName qname;
                    LOGGER.info((Object)"Handling an outbound message");
                    this.getHeaderData();
                    SOAPMessage msg = context.getMessage();
                    SOAPPart sp = msg.getSOAPPart();
                    SOAPEnvelope env = sp.getEnvelope();
                    SOAPHeader sh = env.addHeader();
                    SOAPBody sb = env.getBody();
                    if (this.action != null) {
                        qname = new QName("http://www.w3.org/2005/08/addressing", "Action");
                        SOAPHeaderElement saction = sh.addHeaderElement(qname);
                        boolean must = true;
                        saction.setMustUnderstand(must);
                        saction.setValue(this.action);
                    }
                    if (this.relatesTo != null) {
                        qname = new QName("http://www.w3.org/2005/08/addressing", "RelatesTo");
                        SOAPHeaderElement relates = sh.addHeaderElement(qname);
                        relates.setValue(this.relatesTo);
                    }
                    if (this.from != null) {
                        qname = new QName("http://www.w3.org/2005/08/addressing", "From");
                        QName child = new QName("http://www.w3.org/2005/08/addressing", "Address");
                        SOAPHeaderElement efrom = sh.addHeaderElement(qname);
                        SOAPElement address = efrom.addChildElement(child);
                        address.setValue(this.from);
                    }
                    if (this.messageId != null) {
                        qname = new QName("http://www.w3.org/2005/08/addressing", "MessageID");
                        SOAPHeaderElement message = sh.addHeaderElement(qname);
                        message.setValue(this.messageId);
                    }
                    if (this.to != null) {
                        qname = new QName("http://www.w3.org/2005/08/addressing", "To");
                        SOAPHeaderElement sto = sh.addHeaderElement(qname);
                        sto.setValue(this.to);
                    }
                    SOAPHeaderElement directHeader = sh.addHeaderElement(new QName("urn:direct:addressing", "addressBlock"));
                    directHeader.setPrefix("direct");
                    directHeader.setRole("urn:direct:addressing:destination");
                    directHeader.setRelay(true);
                    if (StringUtils.isNotBlank((String)this.directFrom)) {
                        SOAPElement directFromElement = directHeader.addChildElement(new QName("from"));
                        directFromElement.setPrefix("direct");
                        URI uri = new URI(this.directFrom);
                        directFromElement.setValue(new URI("mailto", uri.getSchemeSpecificPart(), null).toString());
                    }
                    if (StringUtils.isNotBlank((String)this.directTo)) {
                        SOAPElement directToElement = directHeader.addChildElement(new QName("to"));
                        directToElement.setPrefix("direct");
                        URI uri = new URI(this.directTo);
                        directToElement.setValue(new URI("mailto", uri.getSchemeSpecificPart(), null).toString());
                    }
                    SOAPElement directMetadataLevelElement = directHeader.addChildElement(new QName("metadata-level"));
                    directMetadataLevelElement.setPrefix("direct");
                    directMetadataLevelElement.setValue(MetadataLevelEnum.MINIMAL.getLevel());
                    break block23;
                }
                LOGGER.info((Object)"Handling an inbound message");
                this.messageId = null;
                this.action = null;
                this.endpoint = null;
                this.from = null;
                this.to = null;
                this.remoteHost = null;
                this.thisHost = null;
                this.pid = null;
                this.relatesTo = null;
                this.directFrom = null;
                this.directTo = null;
                this.directMetadataLevel = null;
                SOAPMessage msg = context.getMessage();
                ServletRequest sr = (ServletRequest)context.get((Object)"javax.xml.ws.servlet.request");
                if (sr != null) {
                    this.remoteHost = sr.getRemoteHost();
                    this.thisHost = sr.getServerName();
                    this.pid = this.getPID();
                }
                SOAPPart sp = msg.getSOAPPart();
                SOAPEnvelope env = sp.getEnvelope();
                SOAPHeader sh = env.getHeader();
                Iterator it = sh.extractAllHeaderElements();
                while (it.hasNext()) {
                    Node address;
                    int i;
                    NodeList reps;
                    Node header = (Node)it.next();
                    LOGGER.info((Object)header.getNodeName());
                    if (StringUtils.contains((String)header.toString(), (String)"MessageID")) {
                        this.messageId = header.getTextContent();
                        LOGGER.info((Object)this.messageId);
                        continue;
                    }
                    if (StringUtils.contains((String)header.toString(), (String)"Action")) {
                        this.action = header.getTextContent();
                        LOGGER.info((Object)this.action);
                        continue;
                    }
                    if (StringUtils.contains((String)header.toString(), (String)"RelatesTo")) {
                        this.relatesTo = header.getTextContent();
                        LOGGER.info((Object)this.action);
                        continue;
                    }
                    if (StringUtils.contains((String)header.toString(), (String)"ReplyTo")) {
                        reps = header.getChildNodes();
                        for (i = 0; i < reps.getLength(); ++i) {
                            address = reps.item(i);
                            LOGGER.info((Object)address.getNodeName());
                            if (!StringUtils.contains((String)address.getNodeName(), (String)"Address")) continue;
                            this.endpoint = address.getTextContent();
                            LOGGER.info((Object)this.endpoint);
                        }
                        continue;
                    }
                    if (StringUtils.contains((String)header.toString(), (String)"From")) {
                        reps = header.getChildNodes();
                        for (i = 0; i < reps.getLength(); ++i) {
                            address = reps.item(i);
                            LOGGER.info((Object)address.getNodeName());
                            if (!StringUtils.contains((String)address.getNodeName(), (String)"Address")) continue;
                            this.from = address.getTextContent();
                            LOGGER.info((Object)this.from);
                        }
                        continue;
                    }
                    if (StringUtils.contains((String)header.toString(), (String)"To")) {
                        this.to = header.getTextContent();
                        LOGGER.info((Object)this.to);
                        continue;
                    }
                    if (!StringUtils.contains((String)header.toString(), (String)"addressBlock")) continue;
                    NodeList childNodes = header.getChildNodes();
                    for (i = 0; i < childNodes.getLength(); ++i) {
                        Node node = childNodes.item(i);
                        if (StringUtils.contains((String)node.getNodeName(), (String)"from")) {
                            this.directFrom = node.getTextContent();
                            LOGGER.info((Object)this.directFrom);
                            continue;
                        }
                        if (StringUtils.contains((String)node.getNodeName(), (String)"to")) {
                            this.directTo = node.getTextContent();
                            LOGGER.info((Object)this.directTo);
                            continue;
                        }
                        if (!StringUtils.contains((String)node.getNodeName(), (String)"metadata-level")) continue;
                        this.directMetadataLevel = node.getTextContent();
                        LOGGER.info((Object)this.directMetadataLevel);
                    }
                }
                this.setHeaderData();
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Error handling SOAP message.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public Set<QName> getHeaders() {
        HashSet<QName> set = new HashSet<QName>();
        set.add(new QName("http://www.w3.org/2005/08/addressing", "Action"));
        set.add(new QName("http://www.w3.org/2005/08/addressing", "MessageID"));
        set.add(new QName("http://www.w3.org/2005/08/addressing", "To"));
        set.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        return set;
    }

    protected String getMessageEncoding(SOAPMessage msg) throws SOAPException {
        String encoding = "utf-8";
        if (msg.getProperty("javax.xml.soap.character-set-encoding") != null) {
            encoding = msg.getProperty("javax.xml.soap.character-set-encoding").toString();
        }
        return encoding;
    }

    protected void dumpSOAPMessage(SOAPMessage msg) {
        if (msg == null) {
            LOGGER.info((Object)"SOAP Message is null");
            return;
        }
        LOGGER.info((Object)"");
        LOGGER.info((Object)"--------------------");
        LOGGER.info((Object)" DUMP OF SOAP MESSAGE");
        LOGGER.info((Object)"--------------------");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)baos);
            LOGGER.info((Object)baos.toString(this.getMessageEncoding(msg)));
            String values = msg.getSOAPBody().getTextContent();
            LOGGER.trace((Object)("Included values:" + values));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unable to dump soap message.", (Throwable)e);
        }
    }

    public boolean handleFault(SOAPMessageContext context) {
        LOGGER.info((Object)"ServerSOAPHandler.handleFault");
        boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outbound) {
            LOGGER.info((Object)"Direction=outbound (handleFault)");
        } else {
            LOGGER.info((Object)"Direction=inbound (handleFault)");
        }
        try {
            SOAPMessage msg = context.getMessage();
            if (context.getMessage().getSOAPBody().getFault() != null) {
                String detailName = null;
                try {
                    detailName = context.getMessage().getSOAPBody().getFault().getDetail().getFirstChild().getLocalName();
                    LOGGER.info((Object)("detailName=" + detailName));
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"Unable to extract detailName", (Throwable)e);
                }
            }
        }
        catch (SOAPException e) {
            LOGGER.warn((Object)"Error handling fault", (Throwable)e);
        }
        return true;
    }

    protected void getHeaderData() {
        Long threadId = new Long(Thread.currentThread().getId());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("GTHREAD ID " + threadId));
        }
        ThreadData threadData = new ThreadData(threadId);
        this.messageId = threadData.getMessageId();
        this.to = threadData.getTo();
        this.relatesTo = threadData.getRelatesTo();
        this.action = threadData.getAction();
        this.thisHost = threadData.getThisHost();
        this.remoteHost = threadData.getRemoteHost();
        this.pid = threadData.getPid();
        this.from = threadData.getFrom();
        this.directFrom = threadData.getDirectFrom();
        this.directTo = threadData.getDirectTo();
        this.directMetadataLevel = threadData.getDirectMetadataLevel();
    }

    protected void setHeaderData() {
        Long threadId = new Long(Thread.currentThread().getId());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("GTHREAD ID " + threadId));
        }
        ThreadData threadData = new ThreadData(threadId);
        threadData.setReplyAddress(this.endpoint);
        threadData.setMessageId(this.messageId);
        threadData.setAction(this.action);
        threadData.setThisHost(this.thisHost);
        threadData.setRemoteHost(this.remoteHost);
        threadData.setTo(this.to);
        threadData.setPid(this.pid);
        threadData.setFrom(this.from);
        threadData.setDirectFrom(this.directFrom);
        threadData.setDirectTo(this.directTo);
        threadData.setDirectMetadataLevel(this.directMetadataLevel);
    }

    public String getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return processName.split("@")[0];
    }
}

