/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.common;

import ihe.iti.xds_b._2007.ObjectFactory;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.activation.MimetypesFileTypeMap;
import javax.xml.namespace.QName;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ClassificationType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExternalIdentifierType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExtrinsicObjectType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.SlotType1;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.nhindirect.xd.common.DirectDocumentUtils;
import org.nhindirect.xd.common.exception.MetadataException;
import org.nhindirect.xd.common.type.ClassificationTypeEnum;
import org.nhindirect.xd.common.type.ExternalIdentifierTypeEnum;
import org.nhindirect.xd.common.type.ExtrinsicObjectTypeEnum;
import org.nhindirect.xd.common.type.FormatCodeEnum;
import org.nhindirect.xd.common.type.SlotType1Enum;
import org.nhindirect.xd.common.type.SubmitObjectsRequestEnum;
import org.nhindirect.xd.transform.pojo.SimplePerson;
import org.nhindirect.xd.transform.util.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectDocument2 {
    private static final Logger log = LoggerFactory.getLogger(DirectDocument2.class);
    private byte[] data;
    private Metadata metadata;

    public DirectDocument2() {
        this.metadata = new Metadata();
    }

    public DirectDocument2(File file) throws IOException {
        this.data = FileUtils.readFileToByteArray((File)file);
        this.metadata = new Metadata(file);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.metadata.setHash(DirectDocument2.getSha1Hash(data));
        this.metadata.setSize(new Long(data.length));
    }

    public static String getSha1Hash(byte[] bytes) {
        return DirectDocument2.getSha1Hash(new String(bytes));
    }

    public static String getSha1Hash(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Unable to calculate hash, returning null.", (Throwable)e);
            return null;
        }
        messageDigest.update(string.getBytes(), 0, string.length());
        byte[] sha1hash = messageDigest.digest();
        char[] hex = Hex.encodeHex((byte[])sha1hash);
        String newret = new String(hex);
        return newret;
    }

    public static class Metadata {
        private String mimeType;
        private String id;
        private String description;
        private Date creationTime;
        private String languageCode;
        private Date serviceStartTime;
        private Date serviceStopTime;
        private SimplePerson sourcePatient = new SimplePerson();
        private String authorPerson;
        private List<String> authorInstitution = new ArrayList<String>();
        private String authorRole;
        private String authorSpecialty;
        private String classCode;
        private String classCode_localized;
        private String confidentialityCode;
        private String confidentialityCode_localized;
        private String formatCode;
        private String formatCode_localized;
        private String healthcareFacilityTypeCode;
        private String healthcareFacilityTypeCode_localized;
        private String practiceSettingCode;
        private String practiceSettingCode_localized;
        private String loinc;
        private String loinc_localized;
        private String patientId;
        private String uniqueId;
        private String hash;
        private Long size;
        private String submissionSetStatus;
        private String uri;

        public Metadata() {
            this.id = UUID.randomUUID().toString();
            this.submissionSetStatus = "Original";
        }

        public Metadata(File file) throws IOException {
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
            mimetypesFileTypeMap.addMimeTypes("application/msword doc dot wiz rtf");
            mimetypesFileTypeMap.addMimeTypes("application/pdf pdf");
            mimetypesFileTypeMap.addMimeTypes("application/postscript ai eps ps");
            mimetypesFileTypeMap.addMimeTypes("application/vnd.ms-excel xls xlw xla xlc xlm xlt");
            mimetypesFileTypeMap.addMimeTypes("application/vnd.ms-powerpoint ppt pps pot");
            mimetypesFileTypeMap.addMimeTypes("application/x-javascript js");
            mimetypesFileTypeMap.addMimeTypes("application/x-asap asp");
            mimetypesFileTypeMap.addMimeTypes("application/x-latex latex");
            mimetypesFileTypeMap.addMimeTypes("application/x-tar tar");
            mimetypesFileTypeMap.addMimeTypes("application/x-texinfo texinfo texi");
            mimetypesFileTypeMap.addMimeTypes("application/zip zip");
            mimetypesFileTypeMap.addMimeTypes("text/css css");
            mimetypesFileTypeMap.addMimeTypes("text/html htm html");
            mimetypesFileTypeMap.addMimeTypes("text/plain txt");
            mimetypesFileTypeMap.addMimeTypes("text/richtext rtx");
            mimetypesFileTypeMap.addMimeTypes("text/xml xml");
            this.mimeType = mimetypesFileTypeMap.getContentType(file);
            this.size = file.length();
            this.hash = DirectDocument2.getSha1Hash(FileUtils.readFileToString((File)file));
        }

        protected ExtrinsicObjectType generateExtrinsicObjectType() {
            ExtrinsicObjectType eot = new ExtrinsicObjectType();
            eot.setId(this.id);
            eot.setMimeType(this.mimeType);
            eot.setObjectType(ExtrinsicObjectTypeEnum.DOC.getObjectType());
            List<SlotType1> slots = eot.getSlot();
            DirectDocumentUtils.addSlot(slots, DirectDocumentUtils.makeSlot(SlotType1Enum.CREATION_TIME, this.creationTime != null ? new SimpleDateFormat("yyyyMMdd").format(this.creationTime) : null));
            DirectDocumentUtils.addSlot(slots, DirectDocumentUtils.makeSlot(SlotType1Enum.LANGUAGE_CODE, this.languageCode));
            DirectDocumentUtils.addSlot(slots, DirectDocumentUtils.makeSlot(SlotType1Enum.SERVICE_START_TIME, this.serviceStartTime != null ? new SimpleDateFormat("yyyyMMddHHmm").format(this.serviceStartTime) : null));
            DirectDocumentUtils.addSlot(slots, DirectDocumentUtils.makeSlot(SlotType1Enum.SERVICE_STOP_TIME, this.serviceStopTime != null ? new SimpleDateFormat("yyyyMMddHHmm").format(this.serviceStopTime) : null));
            DirectDocumentUtils.addSlot(slots, DirectDocumentUtils.makeSlot(SlotType1Enum.SOURCE_PATIENT_ID, this.sourcePatient.getLocalId() + "^^^&" + this.sourcePatient.getLocalOrg() + "&ISO"));
            DirectDocumentUtils.addSlot(slots, DirectDocumentUtils.makeSlot(SlotType1Enum.SOURCE_PATIENT_INFO, this.sourcePatient));
            DirectDocumentUtils.addSlot(slots, DirectDocumentUtils.makeSlot(SlotType1Enum.HASH, this.hash));
            DirectDocumentUtils.addSlot(slots, DirectDocumentUtils.makeSlot(SlotType1Enum.SIZE, this.size == null ? null : String.valueOf(this.size)));
            DirectDocumentUtils.addSlot(slots, DirectDocumentUtils.makeSlot(SlotType1Enum.URI, this.uri == null ? null : this.uri));
            eot.setName(DirectDocumentUtils.makeInternationalStringType(this.classCode_localized));
            eot.setDescription(DirectDocumentUtils.makeInternationalStringType(this.description));
            ClassificationType authorClassification = new ClassificationType();
            authorClassification.setClassifiedObject(this.id);
            authorClassification.setNodeRepresentation("");
            authorClassification.setId(ClassificationTypeEnum.DOC_AUTHOR.getClassificationId());
            authorClassification.setClassificationScheme(ClassificationTypeEnum.DOC_AUTHOR.getClassificationScheme());
            List<SlotType1> authorClassificationSlots = authorClassification.getSlot();
            DirectDocumentUtils.addSlot(authorClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.AUTHOR_PERSON, this.authorPerson));
            DirectDocumentUtils.addSlot(authorClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.AUTHOR_INSTITUTION, this.authorInstitution));
            DirectDocumentUtils.addSlot(authorClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.AUTHOR_ROLE, this.authorRole));
            DirectDocumentUtils.addSlot(authorClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.AUTHOR_SPECIALTY, this.authorSpecialty));
            eot.getClassification().add(authorClassification);
            if (this.classCode != null) {
                ClassificationType classCodeClassification = new ClassificationType();
                classCodeClassification.setClassifiedObject(this.id);
                classCodeClassification.setNodeRepresentation(this.classCode);
                classCodeClassification.setName(DirectDocumentUtils.makeInternationalStringType(this.classCode_localized));
                classCodeClassification.setId(ClassificationTypeEnum.DOC_CLASS_CODE.getClassificationId());
                classCodeClassification.setClassificationScheme(ClassificationTypeEnum.DOC_CLASS_CODE.getClassificationScheme());
                List<SlotType1> classCodeClassificationSlots = classCodeClassification.getSlot();
                DirectDocumentUtils.addSlot(classCodeClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.CODING_SCHEME, ClassificationTypeEnum.DOC_CLASS_CODE.getCodingScheme()));
                eot.getClassification().add(classCodeClassification);
            }
            if (this.confidentialityCode != null) {
                ClassificationType confidentialityCodeClassification = new ClassificationType();
                confidentialityCodeClassification.setClassifiedObject(this.id);
                confidentialityCodeClassification.setNodeRepresentation(this.confidentialityCode);
                confidentialityCodeClassification.setName(DirectDocumentUtils.makeInternationalStringType(this.confidentialityCode_localized));
                confidentialityCodeClassification.setId(ClassificationTypeEnum.DOC_CONFIDENTIALITY_CODE.getClassificationId());
                confidentialityCodeClassification.setClassificationScheme(ClassificationTypeEnum.DOC_CONFIDENTIALITY_CODE.getClassificationScheme());
                List<SlotType1> confidentialityCodeClassificationSlots = confidentialityCodeClassification.getSlot();
                DirectDocumentUtils.addSlot(confidentialityCodeClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.CODING_SCHEME, ClassificationTypeEnum.DOC_CONFIDENTIALITY_CODE.getCodingScheme()));
                eot.getClassification().add(confidentialityCodeClassification);
            }
            if (this.formatCode != null) {
                ClassificationType formatCodeClassification = new ClassificationType();
                formatCodeClassification.setClassifiedObject(this.id);
                formatCodeClassification.setNodeRepresentation(this.formatCode);
                formatCodeClassification.setName(DirectDocumentUtils.makeInternationalStringType(this.formatCode_localized));
                formatCodeClassification.setId(ClassificationTypeEnum.DOC_FORMAT_CODE.getClassificationId());
                formatCodeClassification.setClassificationScheme(ClassificationTypeEnum.DOC_FORMAT_CODE.getClassificationScheme());
                List<SlotType1> formatCodeClassificationSlots = formatCodeClassification.getSlot();
                DirectDocumentUtils.addSlot(formatCodeClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.CODING_SCHEME, ClassificationTypeEnum.DOC_FORMAT_CODE.getCodingScheme()));
                eot.getClassification().add(formatCodeClassification);
            }
            if (this.healthcareFacilityTypeCode != null) {
                ClassificationType healthcareFacilityTypeCodeClassification = new ClassificationType();
                healthcareFacilityTypeCodeClassification.setClassifiedObject(this.id);
                healthcareFacilityTypeCodeClassification.setNodeRepresentation(this.healthcareFacilityTypeCode);
                healthcareFacilityTypeCodeClassification.setName(DirectDocumentUtils.makeInternationalStringType(this.healthcareFacilityTypeCode_localized));
                healthcareFacilityTypeCodeClassification.setId(ClassificationTypeEnum.DOC_HEALTHCARE_FACILITY_TYPE_CODE.getClassificationId());
                healthcareFacilityTypeCodeClassification.setClassificationScheme(ClassificationTypeEnum.DOC_HEALTHCARE_FACILITY_TYPE_CODE.getClassificationScheme());
                List<SlotType1> healthcareFacilityTypeCodeClassificationSlots = healthcareFacilityTypeCodeClassification.getSlot();
                DirectDocumentUtils.addSlot(healthcareFacilityTypeCodeClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.CODING_SCHEME, ClassificationTypeEnum.DOC_HEALTHCARE_FACILITY_TYPE_CODE.getCodingScheme()));
                eot.getClassification().add(healthcareFacilityTypeCodeClassification);
            }
            if (this.practiceSettingCode != null) {
                ClassificationType practiceSettingCodeClassification = new ClassificationType();
                practiceSettingCodeClassification.setClassifiedObject(this.id);
                practiceSettingCodeClassification.setNodeRepresentation(this.practiceSettingCode);
                practiceSettingCodeClassification.setName(DirectDocumentUtils.makeInternationalStringType(this.practiceSettingCode_localized));
                practiceSettingCodeClassification.setId(ClassificationTypeEnum.DOC_PRACTICE_SETTING_CODE.getClassificationId());
                practiceSettingCodeClassification.setClassificationScheme(ClassificationTypeEnum.DOC_PRACTICE_SETTING_CODE.getClassificationScheme());
                List<SlotType1> practiceSettingCodeClassificationSlots = practiceSettingCodeClassification.getSlot();
                DirectDocumentUtils.addSlot(practiceSettingCodeClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.CODING_SCHEME, ClassificationTypeEnum.DOC_PRACTICE_SETTING_CODE.getCodingScheme()));
                eot.getClassification().add(practiceSettingCodeClassification);
            }
            if (this.loinc != null) {
                ClassificationType loincClassification = new ClassificationType();
                loincClassification.setClassifiedObject(this.id);
                loincClassification.setNodeRepresentation(this.loinc);
                loincClassification.setName(DirectDocumentUtils.makeInternationalStringType(this.loinc_localized));
                loincClassification.setId(ClassificationTypeEnum.DOC_LOINC.getClassificationId());
                loincClassification.setClassificationScheme(ClassificationTypeEnum.DOC_LOINC.getClassificationScheme());
                List<SlotType1> loincClassificationSlots = loincClassification.getSlot();
                DirectDocumentUtils.addSlot(loincClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.CODING_SCHEME, ClassificationTypeEnum.DOC_LOINC.getCodingScheme()));
                eot.getClassification().add(loincClassification);
            }
            ExternalIdentifierType xdsDocumentEntry_patientId = new ExternalIdentifierType();
            xdsDocumentEntry_patientId.setValue(this.patientId);
            xdsDocumentEntry_patientId.setRegistryObject(this.id);
            xdsDocumentEntry_patientId.setId(ExternalIdentifierTypeEnum.DOC_PATIENT_ID.getIdentificationId());
            xdsDocumentEntry_patientId.setIdentificationScheme(ExternalIdentifierTypeEnum.DOC_PATIENT_ID.getIdentificationScheme());
            xdsDocumentEntry_patientId.setName(DirectDocumentUtils.makeInternationalStringType(ExternalIdentifierTypeEnum.DOC_PATIENT_ID.getLocalizedString()));
            eot.getExternalIdentifier().add(xdsDocumentEntry_patientId);
            ExternalIdentifierType xdsDocumentEntry_uniqueId = new ExternalIdentifierType();
            xdsDocumentEntry_uniqueId.setValue(this.uniqueId);
            xdsDocumentEntry_uniqueId.setRegistryObject(this.id);
            xdsDocumentEntry_uniqueId.setId(ExternalIdentifierTypeEnum.DOC_UNIQUE_ID.getIdentificationId());
            xdsDocumentEntry_uniqueId.setIdentificationScheme(ExternalIdentifierTypeEnum.DOC_UNIQUE_ID.getIdentificationScheme());
            xdsDocumentEntry_uniqueId.setName(DirectDocumentUtils.makeInternationalStringType(ExternalIdentifierTypeEnum.DOC_UNIQUE_ID.getLocalizedString()));
            eot.getExternalIdentifier().add(xdsDocumentEntry_uniqueId);
            return eot;
        }

        public void setValues(ExtrinsicObjectType eot) throws MetadataException {
            this.mimeType = eot.getMimeType();
            this.id = eot.getId();
            if (eot.getDescription() != null && eot.getDescription().getLocalizedString() != null && !eot.getDescription().getLocalizedString().isEmpty()) {
                this.description = eot.getDescription().getLocalizedString().get(0).getValue();
            }
            for (SlotType1 slot : eot.getSlot()) {
                if (SlotType1Enum.CREATION_TIME.matches(slot.getName())) {
                    if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                    try {
                        this.creationTime = DateUtils.parseDate((String)slot.getValueList().getValue().get(0), (String[])new String[]{"yyyyMMddHHmmss", "yyyyMMddHHmm", "yyyyMMdd"});
                        continue;
                    }
                    catch (ParseException e) {
                        log.error("Unable to parse creationTime", (Throwable)e);
                        throw new MetadataException("Unable to parse creationTime", e);
                    }
                }
                if (SlotType1Enum.LANGUAGE_CODE.matches(slot.getName())) {
                    if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                    this.languageCode = slot.getValueList().getValue().get(0);
                    continue;
                }
                if (SlotType1Enum.SERVICE_START_TIME.matches(slot.getName())) {
                    if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                    try {
                        this.serviceStartTime = DateUtils.parseDate((String)slot.getValueList().getValue().get(0), (String[])new String[]{"yyyyMMddHHmmss", "yyyyMMddHHmm", "yyyyMMdd"});
                        continue;
                    }
                    catch (ParseException e) {
                        log.error("Unable to parse serviceStartTime", (Throwable)e);
                        throw new MetadataException("Unable to parse serviceStartTime", e);
                    }
                }
                if (SlotType1Enum.SERVICE_STOP_TIME.matches(slot.getName())) {
                    if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                    try {
                        this.serviceStopTime = DateUtils.parseDate((String)slot.getValueList().getValue().get(0), (String[])new String[]{"yyyyMMddHHmmss", "yyyyMMddHHmm", "yyyyMMdd"});
                        continue;
                    }
                    catch (ParseException e) {
                        log.error("Unable to parse serviceStopTime", (Throwable)e);
                        throw new MetadataException("Unable to parse serviceStopTime", e);
                    }
                }
                if (SlotType1Enum.SOURCE_PATIENT_ID.matches(slot.getName())) {
                    if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                    String[] tokens = StringUtils.splitPreserveAllTokens((String)slot.getValueList().getValue().get(0), (String)"^");
                    if (tokens != null && tokens.length >= 1) {
                        this.sourcePatient.setLocalId(tokens[0]);
                    } else {
                        this.sourcePatient.setLocalId(slot.getValueList().getValue().get(0));
                    }
                    if (tokens == null || tokens.length < 4 || (tokens = StringUtils.splitPreserveAllTokens((String)slot.getValueList().getValue().get(0), (String)"&")).length < 2) continue;
                    this.sourcePatient.setLocalOrg(tokens[1]);
                    continue;
                }
                if (SlotType1Enum.SOURCE_PATIENT_INFO.matches(slot.getName())) {
                    if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                    for (String value : slot.getValueList().getValue()) {
                        String[] tokens;
                        String[] split;
                        if (StringUtils.startsWith((CharSequence)value, (CharSequence)"PID-3|")) continue;
                        if (StringUtils.startsWith((CharSequence)value, (CharSequence)"PID-5|")) {
                            split = StringUtils.splitPreserveAllTokens((String)value, (String)"|");
                            tokens = StringUtils.splitPreserveAllTokens((String)split[1], (String)"^");
                            if (tokens != null && tokens.length >= 1) {
                                this.sourcePatient.setLastName(tokens[0]);
                            }
                            if (tokens != null && tokens.length >= 2) {
                                this.sourcePatient.setFirstName(tokens[1]);
                            }
                            if (tokens == null || tokens.length < 3) continue;
                            this.sourcePatient.setMiddleName(tokens[2]);
                            continue;
                        }
                        if (StringUtils.startsWith((CharSequence)value, (CharSequence)"PID-7|")) {
                            split = StringUtils.splitPreserveAllTokens((String)value, (String)"|");
                            if (split.length < 2) continue;
                            this.sourcePatient.setBirthDateTime(split[1]);
                            continue;
                        }
                        if (StringUtils.startsWith((CharSequence)value, (CharSequence)"PID-8|")) {
                            split = StringUtils.splitPreserveAllTokens((String)value, (String)"|");
                            if (split.length < 2) continue;
                            this.sourcePatient.setGenderCode(split[1]);
                            continue;
                        }
                        if (!StringUtils.startsWith((CharSequence)value, (CharSequence)"PID-11|")) continue;
                        split = StringUtils.splitPreserveAllTokens((String)value, (String)"|");
                        tokens = StringUtils.splitPreserveAllTokens((String)split[1], (String)"^");
                        if (tokens != null && tokens.length >= 1) {
                            this.sourcePatient.setStreetAddress1(tokens[0]);
                        }
                        if (tokens != null && tokens.length >= 3) {
                            this.sourcePatient.setCity(tokens[2]);
                        }
                        if (tokens != null && tokens.length >= 4) {
                            this.sourcePatient.setState(tokens[3]);
                        }
                        if (tokens != null && tokens.length >= 5) {
                            this.sourcePatient.setZipCode(tokens[4]);
                        }
                        if (tokens == null || tokens.length < 6) continue;
                        this.sourcePatient.setCountry(tokens[5]);
                    }
                    continue;
                }
                if (SlotType1Enum.HASH.matches(slot.getName())) {
                    if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                    this.hash = slot.getValueList().getValue().get(0);
                    continue;
                }
                if (SlotType1Enum.URI.matches(slot.getName())) {
                    if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                    this.uri = slot.getValueList().getValue().get(0);
                    continue;
                }
                if (!SlotType1Enum.SIZE.matches(slot.getName()) || !DirectDocumentUtils.slotNotEmpty(slot)) continue;
                this.size = Long.valueOf(slot.getValueList().getValue().get(0));
            }
            for (ClassificationType ct : eot.getClassification()) {
                Object object;
                if (ClassificationTypeEnum.DOC_AUTHOR.matchesScheme(ct.getClassificationScheme())) {
                    for (SlotType1 slot : ct.getSlot()) {
                        if (SlotType1Enum.AUTHOR_PERSON.matches(slot.getName())) {
                            if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                            this.authorPerson = slot.getValueList().getValue().get(0);
                            continue;
                        }
                        if (SlotType1Enum.AUTHOR_INSTITUTION.matches(slot.getName())) {
                            if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                            for (String value : slot.getValueList().getValue()) {
                                this.authorInstitution.add(value);
                            }
                            continue;
                        }
                        if (SlotType1Enum.AUTHOR_ROLE.matches(slot.getName())) {
                            if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                            this.authorRole = slot.getValueList().getValue().get(0);
                            continue;
                        }
                        if (!SlotType1Enum.AUTHOR_SPECIALTY.matches(slot.getName()) || !DirectDocumentUtils.slotNotEmpty(slot)) continue;
                        this.authorSpecialty = slot.getValueList().getValue().get(0);
                    }
                    continue;
                }
                if (ClassificationTypeEnum.DOC_CLASS_CODE.matchesScheme(ct.getClassificationScheme())) {
                    for (SlotType1 slot : ct.getSlot()) {
                        if (!SlotType1Enum.CODING_SCHEME.matches(slot.getName()) || !DirectDocumentUtils.slotNotEmpty(slot)) continue;
                        object = slot.getValueList().getValue().get(0);
                    }
                    this.classCode = ct.getNodeRepresentation();
                    if (ct.getName() == null || ct.getName().getLocalizedString() == null || ct.getName().getLocalizedString().isEmpty()) continue;
                    this.classCode_localized = ct.getName().getLocalizedString().get(0).getValue();
                    continue;
                }
                if (ClassificationTypeEnum.DOC_CONFIDENTIALITY_CODE.matchesScheme(ct.getClassificationScheme())) {
                    for (SlotType1 slot : ct.getSlot()) {
                        if (!SlotType1Enum.CODING_SCHEME.matches(slot.getName()) || !DirectDocumentUtils.slotNotEmpty(slot)) continue;
                        object = slot.getValueList().getValue().get(0);
                    }
                    this.confidentialityCode = ct.getNodeRepresentation();
                    if (ct.getName() == null || ct.getName().getLocalizedString() == null || ct.getName().getLocalizedString().isEmpty()) continue;
                    this.confidentialityCode_localized = ct.getName().getLocalizedString().get(0).getValue();
                    continue;
                }
                if (ClassificationTypeEnum.DOC_FORMAT_CODE.matchesScheme(ct.getClassificationScheme())) {
                    for (SlotType1 slot : ct.getSlot()) {
                        if (!SlotType1Enum.CODING_SCHEME.matches(slot.getName()) || !DirectDocumentUtils.slotNotEmpty(slot)) continue;
                        object = slot.getValueList().getValue().get(0);
                    }
                    this.formatCode = ct.getNodeRepresentation();
                    if (ct.getName() == null || ct.getName().getLocalizedString() == null || ct.getName().getLocalizedString().isEmpty()) continue;
                    this.formatCode_localized = ct.getName().getLocalizedString().get(0).getValue();
                    continue;
                }
                if (ClassificationTypeEnum.DOC_HEALTHCARE_FACILITY_TYPE_CODE.matchesScheme(ct.getClassificationScheme())) {
                    for (SlotType1 slot : ct.getSlot()) {
                        if (!SlotType1Enum.CODING_SCHEME.matches(slot.getName()) || !DirectDocumentUtils.slotNotEmpty(slot)) continue;
                        object = slot.getValueList().getValue().get(0);
                    }
                    this.healthcareFacilityTypeCode = ct.getNodeRepresentation();
                    if (ct.getName() == null || ct.getName().getLocalizedString() == null || ct.getName().getLocalizedString().isEmpty()) continue;
                    this.healthcareFacilityTypeCode_localized = ct.getName().getLocalizedString().get(0).getValue();
                    continue;
                }
                if (ClassificationTypeEnum.DOC_PRACTICE_SETTING_CODE.matchesScheme(ct.getClassificationScheme())) {
                    for (SlotType1 slot : ct.getSlot()) {
                        if (!SlotType1Enum.CODING_SCHEME.matches(slot.getName()) || !DirectDocumentUtils.slotNotEmpty(slot)) continue;
                        object = slot.getValueList().getValue().get(0);
                    }
                    this.practiceSettingCode = ct.getNodeRepresentation();
                    if (ct.getName() == null || ct.getName().getLocalizedString() == null || ct.getName().getLocalizedString().isEmpty()) continue;
                    this.practiceSettingCode_localized = ct.getName().getLocalizedString().get(0).getValue();
                    continue;
                }
                if (!ClassificationTypeEnum.DOC_LOINC.matchesScheme(ct.getClassificationScheme())) continue;
                for (SlotType1 slot : ct.getSlot()) {
                    if (!SlotType1Enum.CODING_SCHEME.matches(slot.getName()) || !DirectDocumentUtils.slotNotEmpty(slot)) continue;
                    object = slot.getValueList().getValue().get(0);
                }
                this.loinc = ct.getNodeRepresentation();
                if (ct.getName() == null || ct.getName().getLocalizedString() == null || ct.getName().getLocalizedString().isEmpty()) continue;
                this.loinc_localized = ct.getName().getLocalizedString().get(0).getValue();
            }
            for (ExternalIdentifierType eit : eot.getExternalIdentifier()) {
                if (ExternalIdentifierTypeEnum.DOC_PATIENT_ID.matchesScheme(eit.getIdentificationScheme())) {
                    this.patientId = eit.getValue();
                    continue;
                }
                if (!ExternalIdentifierTypeEnum.DOC_UNIQUE_ID.matchesScheme(eit.getIdentificationScheme())) continue;
                this.uniqueId = eit.getValue();
            }
        }

        public String toString() {
            QName qname = new QName(SubmitObjectsRequestEnum.EXTRINSIC_OBJECT.getNamespaceUri(), SubmitObjectsRequestEnum.EXTRINSIC_OBJECT.getName());
            return XmlUtils.marshal(qname, this.generateExtrinsicObjectType(), ObjectFactory.class);
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Date getCreationTime() {
            return this.creationTime;
        }

        public void setCreationTime(Date creationTime) {
            this.creationTime = creationTime;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public Date getServiceStartTime() {
            return this.serviceStartTime;
        }

        public void setServiceStartTime(Date serviceStartTime) {
            this.serviceStartTime = serviceStartTime;
        }

        public Date getServiceStopTime() {
            return this.serviceStopTime;
        }

        public void setServiceStopTime(Date serviceStopTime) {
            this.serviceStopTime = serviceStopTime;
        }

        public SimplePerson getSourcePatient() {
            return this.sourcePatient;
        }

        public void setSourcePatient(SimplePerson sourcePatient) {
            this.sourcePatient = sourcePatient;
        }

        public String getAuthorPerson() {
            return this.authorPerson;
        }

        public void setAuthorPerson(String authorPerson) {
            this.authorPerson = authorPerson;
        }

        public List<String> getAuthorInstitution() {
            return this.authorInstitution;
        }

        public void setAuthorInstitution(List<String> authorInstitution) {
            this.authorInstitution = authorInstitution;
        }

        public String getAuthorRole() {
            return this.authorRole;
        }

        public void setAuthorRole(String authorRole) {
            this.authorRole = authorRole;
        }

        public String getAuthorSpecialty() {
            return this.authorSpecialty;
        }

        public void setAuthorSpecialty(String authorSpecialty) {
            this.authorSpecialty = authorSpecialty;
        }

        public String getClassCode() {
            return this.classCode;
        }

        public void setClassCode(String classCode) {
            this.setClassCode(classCode, false);
        }

        public void setClassCode(String classCode, boolean setLocalized) {
            this.classCode = classCode;
            if (setLocalized) {
                this.classCode_localized = classCode;
            }
        }

        public String getClassCode_localized() {
            return this.classCode_localized;
        }

        public void setClassCode_localized(String classCodeLocalized) {
            this.classCode_localized = classCodeLocalized;
        }

        public String getConfidentialityCode() {
            return this.confidentialityCode;
        }

        public void setConfidentialityCode(String confidentialityCode) {
            this.setConfidentialityCode(confidentialityCode, false);
        }

        public void setConfidentialityCode(String confidentialityCode, boolean setLocalized) {
            this.confidentialityCode = confidentialityCode;
            if (setLocalized) {
                this.confidentialityCode_localized = confidentialityCode;
            }
        }

        public String getConfidentialityCode_localized() {
            return this.confidentialityCode_localized;
        }

        public void setConfidentialityCode_localized(String confidentialityCodeLocalized) {
            this.confidentialityCode_localized = confidentialityCodeLocalized;
        }

        public String getFormatCode() {
            return this.formatCode;
        }

        public void setFormatCode(String formatCode) {
            this.setFormatCode(formatCode, false);
        }

        public void setFormatCode(String formatCode, boolean setLocalized) {
            this.formatCode = formatCode;
            if (setLocalized) {
                this.formatCode_localized = formatCode;
            }
        }

        public void setFormatCode(FormatCodeEnum formatCode) {
            if (formatCode != null) {
                this.setFormatCode(formatCode.getConceptCode());
                this.setFormatCode_localized(formatCode.getConceptName());
            }
        }

        public String getFormatCode_localized() {
            return this.formatCode_localized;
        }

        public void setFormatCode_localized(String formatCodeLocalized) {
            this.formatCode_localized = formatCodeLocalized;
        }

        public String getHealthcareFacilityTypeCode() {
            return this.healthcareFacilityTypeCode;
        }

        public void setHealthcareFacilityTypeCode(String healthcareFacilityTypeCode) {
            this.setHealthcareFacilityTypeCode(healthcareFacilityTypeCode, false);
        }

        public void setHealthcareFacilityTypeCode(String healthcareFacilityTypeCode, boolean setLocalized) {
            this.healthcareFacilityTypeCode = healthcareFacilityTypeCode;
            if (setLocalized) {
                this.healthcareFacilityTypeCode_localized = healthcareFacilityTypeCode;
            }
        }

        public String getHealthcareFacilityTypeCode_localized() {
            return this.healthcareFacilityTypeCode_localized;
        }

        public void setHealthcareFacilityTypeCode_localized(String healthcareFacilityTypeCodeLocalized) {
            this.healthcareFacilityTypeCode_localized = healthcareFacilityTypeCodeLocalized;
        }

        public String getPracticeSettingCode() {
            return this.practiceSettingCode;
        }

        public void setPracticeSettingCode(String practiceSettingCode) {
            this.setPracticeSettingCode(practiceSettingCode, false);
        }

        public void setPracticeSettingCode(String practiceSettingCode, boolean setLocalized) {
            this.practiceSettingCode = practiceSettingCode;
            if (setLocalized) {
                this.practiceSettingCode_localized = practiceSettingCode;
            }
        }

        public String getPracticeSettingCode_localized() {
            return this.practiceSettingCode_localized;
        }

        public void setPracticeSettingCode_localized(String practiceSettingCodeLocalized) {
            this.practiceSettingCode_localized = practiceSettingCodeLocalized;
        }

        public String getLoinc() {
            return this.loinc;
        }

        public void setLoinc(String loinc) {
            this.setLoinc(loinc, false);
        }

        public void setLoinc(String loinc, boolean setLocalized) {
            this.loinc = loinc;
            if (setLocalized) {
                this.loinc_localized = loinc;
            }
        }

        public String getLoinc_localized() {
            return this.loinc_localized;
        }

        public void setLoinc_localized(String loincLocalized) {
            this.loinc_localized = loincLocalized;
        }

        public String getPatientId() {
            return this.patientId;
        }

        public void setPatientId(String patientId) {
            this.patientId = patientId;
        }

        public String getUniqueId() {
            return this.uniqueId;
        }

        public void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public String getSubmissionSetStatus() {
            return this.submissionSetStatus;
        }

        public void setSubmissionSetStatus(String submissionSetStatus) {
            this.submissionSetStatus = submissionSetStatus;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            if (StringUtils.isNotEmpty((CharSequence)this.hash) && !StringUtils.equalsIgnoreCase((CharSequence)this.hash, (CharSequence)hash)) {
                log.warn("Replacing existing value with new value");
            }
            this.hash = hash;
        }

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long size) {
            if (this.size != null && !this.size.equals(size)) {
                log.warn("Replacing existing size with new value");
            }
            this.size = size;
        }

        public String getURI() {
            return this.uri;
        }

        public void setURI(String uri) {
            if (StringUtils.isNotEmpty((CharSequence)this.uri) && !StringUtils.equalsIgnoreCase((CharSequence)this.uri, (CharSequence)uri)) {
                log.warn("Replacing existing value with new value");
            }
            this.uri = uri;
        }
    }
}

