/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import org.apache.commons.lang3.StringUtils;
import org.nhindirect.xd.common.DirectDocument2;
import org.nhindirect.xd.common.DirectDocuments;
import org.nhindirect.xd.transform.util.type.MimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XdmPackage {
    private static final Logger log = LoggerFactory.getLogger(XdmPackage.class);
    private String messageId;
    private DirectDocuments documents;
    @Deprecated
    private static final String SUFFIX = ".xml";
    private static final int BUFFER = 2048;
    private static final String XDM_SUB_FOLDER = "IHE_XDM/SUBSET01";
    private static final String XDM_METADATA_FILE = "METADATA.xml";

    public XdmPackage() {
        this(UUID.randomUUID().toString());
    }

    public XdmPackage(String messageId) {
        this.messageId = messageId;
        this.documents = new DirectDocuments();
    }

    public void setDocuments(DirectDocuments documents) {
        this.documents = documents;
    }

    public DirectDocuments getDocuments() {
        return this.documents;
    }

    public File toFile() {
        File xdmFile = null;
        try {
            xdmFile = new File(this.messageId + "-xdm.zip");
            FileOutputStream dest = new FileOutputStream(xdmFile);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(dest));
            zipOutputStream.setMethod(8);
            for (DirectDocument2 document : this.documents.getDocuments()) {
                if (document.getData() == null) continue;
                String fileName = document.getMetadata().getId();
                fileName = fileName.replace("urn:uuid:", "");
                fileName = fileName + this.getSuffix(document.getMetadata().getMimeType());
                document.getMetadata().setURI(fileName);
                this.addEntry(zipOutputStream, document.getData(), XDM_SUB_FOLDER + fileName);
            }
            this.addEntry(zipOutputStream, this.documents.getSubmitObjectsRequestAsString().getBytes(), "IHE_XDM/SUBSET01METADATA.xml");
            this.addEntry(zipOutputStream, this.getIndex().getBytes(), "INDEX.htm");
            this.addEntry(zipOutputStream, this.getReadme().getBytes(), "README.txt");
            if (SUFFIX.equals(SUFFIX)) {
                this.addEntry(zipOutputStream, this.getXsl().getBytes(), "IHE_XDM/SUBSET01CCD.xsl");
            }
            zipOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xdmFile;
    }

    private void addEntry(ZipOutputStream zipOutputStream, byte[] data, String fileName) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        BufferedInputStream outputStream = new BufferedInputStream(inputStream);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOutputStream.putNextEntry(zipEntry);
        int count = 0;
        byte[] dataOut = new byte[2048];
        while ((count = outputStream.read(dataOut, 0, 2048)) != -1) {
            zipOutputStream.write(dataOut, 0, count);
        }
    }

    public String getIndex() throws Exception {
        String data;
        try {
            byte[] bytes = this.readFile("INDEX_head.txt");
            data = new String(bytes);
            for (DirectDocument2 document : this.documents.getDocuments()) {
                if (document.getData() == null) continue;
                String file = XDM_SUB_FOLDER + document.getMetadata().getId() + this.getSuffix(document.getMetadata().getMimeType());
                data = data + "<li><a href=\"" + file + "\">" + file + "</a> - " + document.getMetadata().getDescription() + "</li>";
            }
            bytes = this.readFile("INDEX_tail.txt");
            data = data + new String(bytes);
        }
        catch (Exception e) {
            log.error("Unable to access index file.", (Throwable)e);
            throw e;
        }
        return data;
    }

    public String getReadme() throws Exception {
        byte[] bytes;
        try {
            bytes = this.readFile("README.txt");
        }
        catch (Exception e) {
            log.error("Unable to access readme file.", (Throwable)e);
            throw e;
        }
        return new String(bytes);
    }

    public String getXsl() throws Exception {
        byte[] bytes;
        try {
            bytes = this.readFile("CCD.xsl");
        }
        catch (Exception e) {
            log.error("Unable to access xsl file.", (Throwable)e);
            throw e;
        }
        return new String(bytes);
    }

    public static XdmPackage fromXdmZipDataHandler(DataHandler dataHandler) throws Exception {
        File file = null;
        try {
            file = XdmPackage.fileFromDataHandler(dataHandler);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error creating temporary work file, unable to complete transformation.", (Throwable)e);
            }
            throw new Exception("Error creating temporary work file, unable to complete transformation.", e);
        }
        XdmPackage xdmPackage = XdmPackage.fromXdmZipFile(file);
        boolean delete = file.delete();
        if (delete) {
            if (log.isTraceEnabled()) {
                log.trace("Deleted temporary work file " + file.getAbsolutePath());
            }
        } else if (log.isWarnEnabled()) {
            log.warn("Unable to delete temporary work file " + file.getAbsolutePath());
        }
        return xdmPackage;
    }

    public static XdmPackage fromXdmZipFile(File file) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream;
        String subsetDirspec;
        String zname;
        DirectDocuments documents = new DirectDocuments();
        ZipFile zipFile = new ZipFile(file, 1);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        ZipEntry zipEntry = null;
        while (zipEntries.hasMoreElements()) {
            zipEntry = zipEntries.nextElement();
            zname = zipEntry.getName();
            log.info("Processing a ZipEntry named " + zname);
            if (zipEntry.isDirectory() || !XdmPackage.matchName(zname, subsetDirspec = XdmPackage.getSubmissionSetDirspec(zipEntry.getName()), XDM_METADATA_FILE)) continue;
            byteArrayOutputStream = XdmPackage.readData(zipFile, zipEntry);
            documents.setValues(byteArrayOutputStream.toString());
        }
        zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            log.trace("Processing a ZipEntry");
            zipEntry = zipEntries.nextElement();
            zname = zipEntry.getName();
            if (zipEntry.isDirectory() || !StringUtils.contains((CharSequence)(subsetDirspec = XdmPackage.getSubmissionSetDirspec(zipEntry.getName())), (CharSequence)XDM_SUB_FOLDER) || StringUtils.contains((CharSequence)zname, (CharSequence)".xsl") || StringUtils.contains((CharSequence)zname, (CharSequence)XDM_METADATA_FILE)) continue;
            byteArrayOutputStream = XdmPackage.readData(zipFile, zipEntry);
            String digest = DirectDocument2.getSha1Hash(byteArrayOutputStream.toString());
            System.out.println(digest);
            DirectDocument2 document = documents.getDocumentByHash(digest);
            if (document == null) {
                log.warn("Unable to find metadata for document by hash. Creating document with no supporting metadata.");
                document = new DirectDocument2();
                documents.getDocuments().add(document);
            }
            document.setData(byteArrayOutputStream.toByteArray());
        }
        zipFile.close();
        XdmPackage xdmPackage = new XdmPackage();
        xdmPackage.setDocuments(documents);
        return xdmPackage;
    }

    protected static String getSubmissionSetDirspec(String zipEntryName) {
        if (zipEntryName == null) {
            return null;
        }
        String ret = "";
        zipEntryName = zipEntryName.replaceAll("\\\\", "/");
        String[] components = zipEntryName.split("/");
        for (int i = 0; i < components.length - 1; ++i) {
            ret = ret + components[i] + "/";
        }
        if (ret.length() == 0) {
            return "";
        }
        ret = ret.substring(0, ret.length() - 1);
        return ret;
    }

    protected static boolean matchName(String zname, String subsetDirspec, String subsetFilespec) {
        zname = zname.replaceAll("\\\\", "/");
        String zipFilespec = subsetDirspec + "/" + subsetFilespec;
        boolean ret = StringUtils.equals((CharSequence)zname, (CharSequence)zipFilespec);
        return ret;
    }

    private static ByteArrayOutputStream readData(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        InputStream in = zipFile.getInputStream(zipEntry);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int bytesRead = 0;
        byte[] buffer = new byte[2048];
        while ((bytesRead = in.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        in.close();
        return baos;
    }

    private byte[] readFile(String filename) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(filename);
        byte[] bytes = new byte[is.available()];
        is.read(bytes);
        is.close();
        return bytes;
    }

    private static File fileFromDataHandler(DataHandler dh) throws Exception {
        File f = null;
        OutputStream out = null;
        InputStream inputStream = null;
        String fileName = UUID.randomUUID().toString() + ".zip";
        try {
            int len;
            f = new File(fileName);
            inputStream = dh.getInputStream();
            out = new FileOutputStream(f);
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error("File not found - " + fileName, (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("Exception thrown while trying to read file from DataHandler object", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (out != null) {
                out.close();
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Created temporary work file " + f.getAbsolutePath());
        }
        return f;
    }

    private String getSuffix(String mimeType) {
        return "." + MimeType.lookup(mimeType).getSuffix();
    }
}

