/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.proxy;

import ihe.iti.xds_b._2007.DocumentRepositoryPortType;
import ihe.iti.xds_b._2007.DocumentRepositoryService;
import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;
import java.net.URL;
import javax.naming.OperationNotSupportedException;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPBinding;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentRepositoryProxy {
    private static final Logger log = LoggerFactory.getLogger(DocumentRepositoryProxy.class);
    private String endpoint = null;
    private HandlerResolver handlerResolver = null;
    private DocumentRepositoryPortType proxy;

    public DocumentRepositoryProxy(String endpoint) {
        this.endpoint = endpoint;
        this.initProxy();
    }

    public DocumentRepositoryProxy(String endpoint, HandlerResolver handlerResolver) {
        this(endpoint);
        this.handlerResolver = handlerResolver;
        this.initProxy();
    }

    private void initProxy() {
        try {
            URL url = DocumentRepositoryProxy.class.getClassLoader().getResource("XDS.b_DocumentRepositoryWSDLSynchMTOM.wsdl");
            QName qname = new QName("urn:ihe:iti:xds-b:2007", "DocumentRepository_Service");
            DocumentRepositoryService service = new DocumentRepositoryService(url, qname);
            if (this.handlerResolver != null) {
                service.setHandlerResolver(this.handlerResolver);
            }
            this.proxy = service.getDocumentRepositoryPortSoap12(new WebServiceFeature[]{new MTOMFeature(true, 1)});
            BindingProvider bp = (BindingProvider)this.proxy;
            SOAPBinding binding = (SOAPBinding)bp.getBinding();
            binding.setMTOMEnabled(true);
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endpoint);
        }
        catch (Exception e) {
            log.error("Error initializing proxy.", (Throwable)e);
        }
    }

    public RegistryResponseType provideAndRegisterDocumentSetB(ProvideAndRegisterDocumentSetRequestType body) {
        if (this.proxy == null) {
            this.initProxy();
        }
        log.debug("Sending to endpoint: " + this.endpoint);
        return this.proxy.documentRepositoryProvideAndRegisterDocumentSetB(body);
    }

    public RetrieveDocumentSetResponseType retrieveDocumentSet(RetrieveDocumentSetRequestType body) throws Exception {
        if (this.proxy == null) {
            this.initProxy();
        }
        throw new OperationNotSupportedException("Not implemented.");
    }
}

