/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.routing.impl;

import org.apache.commons.lang3.StringUtils;
import org.nhind.config.rest.AddressService;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.Address;
import org.nhindirect.config.model.EntityStatus;
import org.nhindirect.xd.routing.RoutingResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingResolverImpl
extends RoutingResolver {
    private static final Logger log = LoggerFactory.getLogger(RoutingResolverImpl.class);
    private AddressService addressService;

    public RoutingResolverImpl() {
    }

    public RoutingResolverImpl(AddressService addressService) {
        this.addressService = addressService;
    }

    @Override
    public String resolve(String address) {
        Address addr = this.lookup(address);
        if (addr != null) {
            if (StringUtils.isNotBlank((CharSequence)addr.getEndpoint())) {
                return addr.getEndpoint();
            }
            return addr.getEmailAddress();
        }
        return address;
    }

    @Override
    public boolean isSmtpEndpoint(String address) {
        if (address == null) {
            return false;
        }
        Address addr = this.lookup(address);
        if (addr != null && StringUtils.isNotBlank((CharSequence)addr.getType())) {
            return StringUtils.equalsIgnoreCase((CharSequence)addr.getType(), (CharSequence)"SMTP");
        }
        return StringUtils.contains((CharSequence)address, (int)64);
    }

    @Override
    public boolean isXdEndpoint(String address) {
        if (address == null) {
            return false;
        }
        Address addr = this.lookup(address);
        if (addr != null && StringUtils.isNotBlank((CharSequence)addr.getType())) {
            return StringUtils.equalsIgnoreCase((CharSequence)addr.getType(), (CharSequence)"XD");
        }
        return !StringUtils.contains((CharSequence)address, (int)64);
    }

    private Address lookup(String address) {
        if (this.addressService == null) {
            log.warn("Attempt to lookup address with unititialized address service, falling back to default routing.");
            return null;
        }
        try {
            Address addr = this.addressService.getAddress(address);
            if (addr == null || !addr.getStatus().equals((Object)EntityStatus.ENABLED)) {
                if (log.isTraceEnabled()) {
                    log.trace("Unable to find address " + address + " in address store.");
                }
                return null;
            }
            return addr;
        }
        catch (ServiceException e) {
            if (log.isWarnEnabled()) {
                log.warn("Unable to look up address, falling back to default routing.", (Throwable)e);
            }
            return null;
        }
    }
}

