/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.soap;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang3.StringUtils;
import org.nhindirect.xd.soap.SafeThreadData;
import org.nhindirect.xd.soap.type.MetadataLevelEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DirectSOAPHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger log = LoggerFactory.getLogger(DirectSOAPHandler.class);
    public static final String ENDPOINT_ADDRESS = "javax.xml.ws.service.endpoint.address";
    public static final String RESPONSE_NODE_NAME = "RegistryResponse";
    public static final String PNR_NODE_NAME = "ProvideAndRegisterDocumentSetRequest";

    @PostConstruct
    public void init() {
    }

    public void close(MessageContext messageContext) {
    }

    @PreDestroy
    public void destroy() {
    }

    public boolean handleMessage(SOAPMessageContext context) {
        block34: {
            log.info("Entering DirectSOAPHandler.handleMessage(SOAPMessageContext)");
            boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
            try {
                if (outbound) {
                    log.info("Handling an outbound message");
                    boolean isACK = !context.containsKey((Object)ENDPOINT_ADDRESS);
                    SafeThreadData threadData = SafeThreadData.GetThreadInstance(Thread.currentThread().getId());
                    SOAPMessage msg = context.getMessage();
                    this.dumpSOAPMessage(msg);
                    SOAPPart sp = msg.getSOAPPart();
                    SOAPEnvelope env = sp.getEnvelope();
                    if (env.getHeader() != null) {
                        env.getHeader().detachNode();
                    }
                    SOAPHeader sh = env.addHeader();
                    SOAPBody sb = env.getBody();
                    try {
                        QName qname;
                        if (threadData.getAction() != null) {
                            qname = new QName("http://www.w3.org/2005/08/addressing", "Action");
                            SOAPHeaderElement saction = sh.addHeaderElement(qname);
                            boolean must = true;
                            saction.setMustUnderstand(must);
                            saction.setValue(threadData.getAction());
                        }
                        if (threadData.getRelatesTo() != null) {
                            qname = new QName("http://www.w3.org/2005/08/addressing", "RelatesTo");
                            SOAPHeaderElement relates = sh.addHeaderElement(qname);
                            relates.setValue(threadData.getRelatesTo());
                        }
                        if (threadData.getFrom() != null) {
                            qname = new QName("http://www.w3.org/2005/08/addressing", "From");
                            QName child = new QName("http://www.w3.org/2005/08/addressing", "Address");
                            SOAPHeaderElement efrom = sh.addHeaderElement(qname);
                            SOAPElement address = efrom.addChildElement(child);
                            address.setValue(threadData.getFrom());
                        }
                        if (threadData.getMessageId() != null) {
                            qname = new QName("http://www.w3.org/2005/08/addressing", "MessageID");
                            SOAPHeaderElement message = sh.addHeaderElement(qname);
                            message.setValue(threadData.getMessageId());
                        }
                        if (threadData.getTo() != null) {
                            qname = new QName("http://www.w3.org/2005/08/addressing", "To");
                            SOAPHeaderElement sto = sh.addHeaderElement(qname);
                            sto.setValue(threadData.getTo());
                        }
                        SOAPHeaderElement directHeader = sh.addHeaderElement(new QName("urn:direct:addressing", "addressBlock"));
                        directHeader.setPrefix("direct");
                        directHeader.setRole("urn:direct:addressing:destination");
                        directHeader.setRelay(true);
                        if (StringUtils.isNotBlank((CharSequence)threadData.getDirectFrom())) {
                            SOAPElement directFromElement = directHeader.addChildElement(new QName("urn:direct:addressing", "from"));
                            directFromElement.setPrefix("direct");
                            URI uri = new URI(threadData.getDirectFrom());
                            directFromElement.setValue(new URI("mailto", uri.getSchemeSpecificPart(), null).toString());
                        }
                        if (StringUtils.isNotBlank((CharSequence)threadData.getDirectTo())) {
                            String[] directTos;
                            for (String directToAddr : directTos = threadData.getDirectTo().split(";")) {
                                SOAPElement directToElement = directHeader.addChildElement(new QName("urn:direct:addressing", "to"));
                                directToElement.setPrefix("direct");
                                URI uri = new URI(directToAddr);
                                directToElement.setValue(new URI("mailto", uri.getSchemeSpecificPart(), null).toString());
                            }
                        }
                        SOAPElement directMetadataLevelElement = directHeader.addChildElement(new QName("urn:direct:addressing", "metadata-level"));
                        directMetadataLevelElement.setPrefix("direct");
                        directMetadataLevelElement.setValue(MetadataLevelEnum.MINIMAL.getLevel());
                    }
                    catch (Throwable tb) {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to write SOAP Header", tb);
                        }
                        log.error("Failed to write SOAP Header: " + tb.getMessage());
                    }
                    if (isACK) {
                        SafeThreadData.clean(Thread.currentThread().getId());
                    }
                    break block34;
                }
                log.info("Handling an inbound message");
                SOAPMessage msg = context.getMessage();
                boolean isResponse = this.isResponse(msg);
                if (!isResponse) {
                    SafeThreadData.clean(Thread.currentThread().getId());
                }
                SafeThreadData threadData = SafeThreadData.GetThreadInstance(Thread.currentThread().getId());
                ServletRequest sr = (ServletRequest)context.get((Object)"javax.xml.ws.servlet.request");
                if (sr != null) {
                    threadData.setRemoteHost(sr.getRemoteHost());
                    threadData.setThisHost(sr.getServerName());
                    threadData.setPid(this.getPID());
                }
                SOAPPart sp = msg.getSOAPPart();
                SOAPEnvelope env = sp.getEnvelope();
                SOAPHeader sh = env.getHeader();
                Iterator it = sh.extractAllHeaderElements();
                while (it.hasNext()) {
                    try {
                        Node address;
                        int i;
                        NodeList reps;
                        Node header = (Node)it.next();
                        if (StringUtils.contains((CharSequence)header.toString(), (CharSequence)"MessageID")) {
                            threadData.setMessageId(header.getTextContent());
                            continue;
                        }
                        if (StringUtils.contains((CharSequence)header.toString(), (CharSequence)"Action")) {
                            threadData.setAction(header.getTextContent());
                            continue;
                        }
                        if (StringUtils.contains((CharSequence)header.toString(), (CharSequence)"RelatesTo")) {
                            threadData.setRelatesTo(header.getTextContent());
                            continue;
                        }
                        if (StringUtils.contains((CharSequence)header.toString(), (CharSequence)"ReplyTo")) {
                            reps = header.getChildNodes();
                            for (i = 0; i < reps.getLength(); ++i) {
                                address = reps.item(i);
                                if (!StringUtils.contains((CharSequence)address.getNodeName(), (CharSequence)"Address")) continue;
                                threadData.setEndpoint(address.getTextContent());
                            }
                            continue;
                        }
                        if (StringUtils.contains((CharSequence)header.toString(), (CharSequence)"From")) {
                            reps = header.getChildNodes();
                            for (i = 0; i < reps.getLength(); ++i) {
                                address = reps.item(i);
                                if (!StringUtils.contains((CharSequence)address.getNodeName(), (CharSequence)"Address")) continue;
                                threadData.setFrom(address.getTextContent());
                            }
                            continue;
                        }
                        if (StringUtils.contains((CharSequence)header.toString(), (CharSequence)"To")) {
                            threadData.setTo(header.getTextContent());
                            continue;
                        }
                        if (!StringUtils.contains((CharSequence)header.toString(), (CharSequence)"addressBlock")) continue;
                        NodeList childNodes = header.getChildNodes();
                        for (i = 0; i < childNodes.getLength(); ++i) {
                            Node node = childNodes.item(i);
                            if (StringUtils.contains((CharSequence)node.getNodeName(), (CharSequence)"from")) {
                                threadData.setDirectFrom(node.getTextContent());
                                continue;
                            }
                            if (StringUtils.contains((CharSequence)node.getNodeName(), (CharSequence)"to")) {
                                String recipient = node.getTextContent();
                                if (threadData.getDirectTo() == null) {
                                    threadData.setDirectTo(recipient);
                                    continue;
                                }
                                threadData.setDirectTo(threadData.getDirectTo() + ";" + recipient);
                                continue;
                            }
                            if (!StringUtils.contains((CharSequence)node.getNodeName(), (CharSequence)"metadata-level")) continue;
                            threadData.setDirectMetadataLevel(node.getTextContent());
                        }
                    }
                    catch (Throwable tb) {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to read input parameter.", tb);
                            continue;
                        }
                        log.error("Failed to read input parameter.");
                    }
                }
                threadData.save();
            }
            catch (Exception e) {
                log.warn("Error handling SOAP message.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public Set<QName> getHeaders() {
        HashSet<QName> set = new HashSet<QName>();
        set.add(new QName("http://www.w3.org/2005/08/addressing", "Action"));
        set.add(new QName("http://www.w3.org/2005/08/addressing", "MessageID"));
        set.add(new QName("http://www.w3.org/2005/08/addressing", "To"));
        set.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        set.add(new QName("http://www.w3.org/2005/08/addressing", "ReplyTo"));
        return set;
    }

    protected String getMessageEncoding(SOAPMessage msg) throws SOAPException {
        String encoding = "utf-8";
        if (msg.getProperty("javax.xml.soap.character-set-encoding") != null) {
            encoding = msg.getProperty("javax.xml.soap.character-set-encoding").toString();
        }
        return encoding;
    }

    protected void dumpSOAPMessage(SOAPMessage msg) {
        if (msg == null) {
            log.info("SOAP Message is null");
            return;
        }
        log.info("");
        log.info("--------------------");
        log.info(" DUMP OF SOAP MESSAGE");
        log.info("--------------------");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)baos);
            log.info(baos.toString(this.getMessageEncoding(msg)));
            String values = msg.getSOAPBody().getTextContent();
            log.trace("Included values:" + values);
        }
        catch (Exception e) {
            log.warn("Unable to dump soap message.", (Throwable)e);
        }
    }

    public boolean handleFault(SOAPMessageContext context) {
        log.info("ServerSOAPHandler.handleFault");
        boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outbound) {
            log.info("Direction=outbound (handleFault)");
        } else {
            log.info("Direction=inbound (handleFault)");
        }
        try {
            SOAPMessage msg = context.getMessage();
            if (context.getMessage().getSOAPBody().getFault() != null) {
                String detailName = null;
                try {
                    detailName = context.getMessage().getSOAPBody().getFault().getDetail().getFirstChild().getLocalName();
                    log.info("detailName=" + detailName);
                }
                catch (Exception e) {
                    log.warn("Unable to extract detailName", (Throwable)e);
                }
            }
        }
        catch (SOAPException e) {
            log.warn("Error handling fault", (Throwable)e);
        }
        return true;
    }

    public String getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return processName.split("@")[0];
    }

    protected boolean isResponse(SOAPMessage soapMessage) throws SOAPException {
        SOAPBody soapBody;
        Iterator childElements;
        boolean isResponse = false;
        if (soapMessage != null && (childElements = (soapBody = soapMessage.getSOAPBody()).getChildElements()) != null) {
            while (childElements.hasNext()) {
                Node node = (Node)childElements.next();
                String nodeName = node.getNodeName();
                if (StringUtils.equalsIgnoreCase((CharSequence)nodeName, (CharSequence)RESPONSE_NODE_NAME)) {
                    isResponse = true;
                    break;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)nodeName, (CharSequence)PNR_NODE_NAME)) continue;
                isResponse = false;
                break;
            }
        }
        return isResponse;
    }
}

