/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.soap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ThreadData {
    public static final String MESSAGE = "message";
    public static final String ACTION = "action";
    public static final String REPLY = "reply";
    public static final String TO = "to";
    public static final String RELATESTO = "relatesto";
    public static final String THISHOST = "thishost";
    public static final String REMOTEHOST = "remotehost";
    public static final String PID = "pid";
    public static final String FROM = "from";
    public static final String DIRECT_TO = "directTo";
    public static final String DIRECT_FROM = "directFrom";
    public static final String DIRECT_METADATA_LEVEL = "directMetadataLevel";
    private Long threadId = null;
    private static Map<Long, Map<String, String>> threadMap = new HashMap<Long, Map<String, String>>();

    public ThreadData(Long id) {
        this.threadId = id;
    }

    public static void clean(Long id) {
        threadMap.remove(id);
    }

    public void setMessageId(String value) {
        this.setValue(value, MESSAGE);
    }

    public void setFrom(String value) {
        this.setValue(value, FROM);
    }

    public void setThisHost(String value) {
        this.setValue(value, THISHOST);
    }

    public void setRemoteHost(String value) {
        this.setValue(value, REMOTEHOST);
    }

    public void setAction(String value) {
        this.setValue(value, ACTION);
    }

    public void setPid(String value) {
        this.setValue(value, PID);
    }

    public void setReplyAddress(String value) {
        this.setValue(value, REPLY);
    }

    public void setTo(String value) {
        this.setValue(value, TO);
    }

    public void setRelatesTo(String value) {
        this.setValue(value, RELATESTO);
    }

    public void setDirectTo(String value) {
        this.setValue(value, DIRECT_TO);
    }

    public void setDirectFrom(String value) {
        this.setValue(value, DIRECT_FROM);
    }

    public void setDirectMetadataLevel(String value) {
        this.setValue(value, DIRECT_METADATA_LEVEL);
    }

    public String getThisHost() {
        return this.getValue(THISHOST);
    }

    public String getRemoteHost() {
        return this.getValue(REMOTEHOST);
    }

    public String getMessageId() {
        return this.getValue(MESSAGE);
    }

    public String getAction() {
        return this.getValue(ACTION);
    }

    public String getPid() {
        return this.getValue(PID);
    }

    public String getReplyAddress() {
        return this.getValue(REPLY);
    }

    public String getTo() {
        return this.getValue(TO);
    }

    public String getFrom() {
        return this.getValue(FROM);
    }

    public String getRelatesTo() {
        return this.getValue(RELATESTO);
    }

    public String getDirectTo() {
        return this.getValue(DIRECT_TO);
    }

    public String getDirectFrom() {
        return this.getValue(DIRECT_FROM);
    }

    public String getDirectMetadataLevel() {
        return this.getValue(DIRECT_METADATA_LEVEL);
    }

    private void setValue(String value, String key) {
        Map<Object, Object> data = null;
        if (threadMap.containsKey(this.threadId)) {
            data = threadMap.get(this.threadId);
        } else {
            data = new HashMap();
            threadMap.put(this.threadId, data);
        }
        data.put(key, value);
    }

    private String getValue(String key) {
        String ret = null;
        Map<String, String> data = threadMap.get(this.threadId);
        if (data != null) {
            ret = data.get(key);
        }
        return ret;
    }

    protected static Map<Long, Map<String, String>> getThreadMapView() {
        return Collections.unmodifiableMap(threadMap);
    }

    public String toString() {
        Map<String, String> m = threadMap.get(this.threadId);
        if (m != null) {
            StringBuffer sb = new StringBuffer("ThreadData (threadId: " + this.threadId + ")\n");
            for (Map.Entry<String, String> e : m.entrySet()) {
                sb.append(" > " + e.getKey() + ": " + e.getValue() + "\n");
            }
            return sb.toString();
        }
        return "No map found for threadId: " + this.threadId;
    }
}

