/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.transform.impl;

import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.nhindirect.xd.common.DirectDocument2;
import org.nhindirect.xd.common.DirectDocuments;
import org.nhindirect.xd.common.XdmPackage;
import org.nhindirect.xd.common.type.DirectDocumentType;
import org.nhindirect.xd.common.type.FormatCodeEnum;
import org.nhindirect.xd.transform.MimeXdsTransformer;
import org.nhindirect.xd.transform.exception.TransformationException;
import org.nhindirect.xd.transform.util.type.MimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMimeXdsTransformer
implements MimeXdsTransformer {
    private static final Logger log = LoggerFactory.getLogger(DefaultMimeXdsTransformer.class);

    @Override
    public ProvideAndRegisterDocumentSetRequestType transform(MimeMessage mimeMessage) throws TransformationException {
        ProvideAndRegisterDocumentSetRequestType request;
        DirectDocuments documents;
        block21: {
            documents = new DirectDocuments();
            byte[] xdsDocument = null;
            String xdsMimeType = null;
            FormatCodeEnum xdsFormatCode = null;
            DirectDocumentType documentType = null;
            try {
                Date sentDate = mimeMessage.getSentDate();
                String subject = mimeMessage.getSubject();
                String from = mimeMessage.getFrom()[0].toString();
                Address[] recipients = mimeMessage.getAllRecipients();
                if (MimeType.TEXT_PLAIN.matches(mimeMessage.getContentType())) {
                    log.info("Handling plain mail (no attachments) - " + mimeMessage.getContentType());
                    documentType = DirectDocumentType.lookup(mimeMessage);
                    xdsFormatCode = documentType.getFormatCode();
                    xdsMimeType = documentType.getMimeType().getType();
                    xdsDocument = ((String)mimeMessage.getContent()).getBytes();
                    documents.getDocuments().add(this.getDocument(sentDate, from, xdsMimeType, xdsFormatCode, xdsDocument, documentType));
                    documents.setSubmissionSet(this.getSubmissionSet(subject, sentDate, from, recipients, xdsDocument, documentType));
                    break block21;
                }
                if (MimeType.MULTIPART.matches(mimeMessage.getContentType())) {
                    BodyPart bodyPart;
                    int i;
                    log.info("Handling multipart/mixed - " + mimeMessage.getContentType());
                    MimeMultipart mimeMultipart = (MimeMultipart)mimeMessage.getContent();
                    BodyPart xdmBodyPart = null;
                    for (i = 0; i < mimeMultipart.getCount(); ++i) {
                        bodyPart = mimeMultipart.getBodyPart(i);
                        documentType = DirectDocumentType.lookup(bodyPart);
                        if (!DirectDocumentType.XDM.equals((Object)documentType)) continue;
                        xdmBodyPart = bodyPart;
                    }
                    for (i = 0; i < mimeMultipart.getCount(); ++i) {
                        if (xdmBodyPart != null) {
                            XdmPackage xdmPackage = XdmPackage.fromXdmZipDataHandler(xdmBodyPart.getDataHandler());
                            System.out.println("XDM FILE FOUND");
                            documents = xdmPackage.getDocuments();
                            break block21;
                        }
                        bodyPart = mimeMultipart.getBodyPart(i);
                        if (bodyPart.getSize() <= 0) {
                            log.warn("Empty body, skipping");
                            continue;
                        }
                        documentType = DirectDocumentType.lookup(bodyPart);
                        if (log.isInfoEnabled()) {
                            log.info("File name: " + bodyPart.getFileName());
                        }
                        if (log.isInfoEnabled()) {
                            log.info("Content type: " + bodyPart.getContentType());
                        }
                        if (log.isInfoEnabled()) {
                            log.info("DocumentType: " + documentType.toString());
                        }
                        xdsFormatCode = documentType.getFormatCode();
                        xdsMimeType = documentType.getMimeType().getType();
                        if (DirectDocumentType.UNKNOWN.equals((Object)documentType)) {
                            xdsMimeType = bodyPart.getContentType();
                        }
                        xdsDocument = DefaultMimeXdsTransformer.read(bodyPart);
                        documents.getDocuments().add(this.getDocument(sentDate, from, xdsMimeType, xdsFormatCode, xdsDocument, documentType));
                        documents.setSubmissionSet(this.getSubmissionSet(subject, sentDate, from, recipients, xdsDocument, documentType));
                    }
                    break block21;
                }
                if (log.isWarnEnabled()) {
                    log.warn("Message content type (" + mimeMessage.getContentType() + ") is not supported, skipping");
                }
            }
            catch (MessagingException e) {
                if (log.isErrorEnabled()) {
                    log.error("Unexpected MessagingException occured while handling MimeMessage", (Throwable)e);
                }
                throw new TransformationException("Unable to complete transformation.", e);
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error("Unexpected IOException occured while handling MimeMessage", (Throwable)e);
                }
                throw new TransformationException("Unable to complete transformation.", e);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("Unexpected Exception occured while handling MimeMessage", (Throwable)e);
                }
                throw new TransformationException("Unable to complete transformation", e);
            }
        }
        try {
            request = documents.toProvideAndRegisterDocumentSetRequestType();
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("Unexpected IOException occured while transforming to ProvideAndRegisterDocumentSetRequestType", (Throwable)e);
            }
            throw new TransformationException("Unable to complete transformation", e);
        }
        return request;
    }

    private DirectDocuments.SubmissionSet getSubmissionSet(String subject, Date sentDate, String auth, Address[] recipients, byte[] xdsDocument, DirectDocumentType documentType) throws Exception {
        DirectDocuments.SubmissionSet submissionSet = new DirectDocuments.SubmissionSet();
        submissionSet.setAuthorTelecommunication(auth);
        submissionSet.setSourceId("TODO");
        submissionSet.setSubmissionTime(sentDate);
        submissionSet.setUniqueId(UUID.randomUUID().toString());
        for (Address address : recipients) {
            submissionSet.getIntendedRecipient().add("||^^Internet^" + address.toString());
        }
        documentType.parse(new String(xdsDocument), submissionSet);
        return submissionSet;
    }

    private DirectDocument2 getDocument(Date sentDate, String auth, String xdsMimeType, FormatCodeEnum xdsFormatCode, byte[] xdsDocument, DirectDocumentType documentType) throws Exception {
        DirectDocument2 document = new DirectDocument2();
        DirectDocument2.Metadata metadata = document.getMetadata();
        metadata.setMimeType(xdsMimeType);
        metadata.setUniqueId(UUID.randomUUID().toString());
        if (xdsFormatCode != null) {
            metadata.setFormatCode(xdsFormatCode);
        }
        documentType.parse(new String(xdsDocument), metadata);
        document.setData(xdsDocument);
        return document;
    }

    private static byte[] read(BodyPart bodyPart) throws MessagingException, IOException {
        InputStream inputStream = bodyPart.getInputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int data = 0;
        byte[] buffer = new byte[1024];
        while ((data = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, data);
        }
        return outputStream.toByteArray();
    }
}

