/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.transform.parse;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nhindirect.xd.common.DirectDocuments;

public class ParserHL7 {
    public static List<String> parseRecipients(DirectDocuments documents) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String recipient : documents.getSubmissionSet().getIntendedRecipient()) {
            if (recipient.startsWith("|")) {
                String address = StringUtils.remove((String)recipient, (String)"|");
                ret.add(StringUtils.splitPreserveAllTokens((String)address, (String)"^")[0]);
                continue;
            }
            String id = ParserHL7.getId(recipient);
            ret.add(id);
        }
        return ret;
    }

    public static List<String> parseDirectRecipients(DirectDocuments documents) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String recipient : documents.getSubmissionSet().getIntendedRecipient()) {
            String address = StringUtils.splitPreserveAllTokens((String)recipient, (String)"|")[2];
            ret.add(ParserHL7.parseXTN(address));
        }
        return ret;
    }

    public static String parseXTN(String address) {
        return StringUtils.splitPreserveAllTokens((String)address, (String)"^")[3];
    }

    public static String getId(String recipient) {
        String address;
        String ret = null;
        byte[] testp = recipient.getBytes();
        int pcount = 0;
        for (byte p : testp) {
            if ((char)p != '|') continue;
            ++pcount;
        }
        System.out.println("count = " + pcount);
        if (pcount > 1) {
            address = StringUtils.splitPreserveAllTokens((String)recipient, (String)"|")[2];
            String test = StringUtils.splitPreserveAllTokens((String)address, (String)"^")[3];
            int stop = test.indexOf("<");
            if (stop > 0) {
                test = test.substring(0, stop);
            }
            System.out.println(test);
            ret = test;
        } else {
            address = StringUtils.splitPreserveAllTokens((String)recipient, (String)"|")[1];
            String test = StringUtils.splitPreserveAllTokens((String)address, (String)"^")[0];
            System.out.println(test);
            ret = test;
        }
        System.out.println("about to test ret " + ret);
        return ret;
    }
}

