/*
 * Decompiled with CFR 0.152.
 */
package com.gsihealth.auditclient;

import com.gsihealth.auditclient.CodedValueFactory;
import com.gsihealth.auditclient.SyslogClient;
import com.gsihealth.auditclient.type.AuditMethodEnum;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.xml.xml.schema._7f0d86bd.healthcare_security_audit.ActiveParticipantType;
import org.xml.xml.schema._7f0d86bd.healthcare_security_audit.AuditMessage;
import org.xml.xml.schema._7f0d86bd.healthcare_security_audit.CodedValueType;
import org.xml.xml.schema._7f0d86bd.healthcare_security_audit.EventIdentificationType;
import org.xml.xml.schema._7f0d86bd.healthcare_security_audit.ObjectFactory;
import org.xml.xml.schema._7f0d86bd.healthcare_security_audit.ParticipantObjectIdentificationType;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuditMessageGenerator {
    private Short VAL1 = Short.parseShort("1");
    private Short VAL2 = Short.parseShort("2");
    private Short VAL20 = Short.parseShort("20");
    private AuditMethodEnum auditMethod = null;
    private String auditFile = null;
    private String auditHost = null;
    private String auditPort = null;

    public AuditMessageGenerator(String auditFile) {
        this.auditMethod = AuditMethodEnum.FILE;
        this.auditFile = auditFile;
    }

    public AuditMessageGenerator(String auditHost, String auditPort) {
        this.auditMethod = AuditMethodEnum.SYSLOG;
        this.auditHost = auditHost;
        this.auditPort = auditPort;
    }

    public void provideAndRegisterAudit(String sourceMessageId, String sourceName, String replyTo, String to, String thisName, String patientId, String subsetId, String pid) throws Exception {
        try {
            AuditMessage am = new AuditMessage();
            CodedValueType importcode = null;
            CodedValueType sourceCode = null;
            CodedValueType pnrCode = null;
            CodedValueType patientNumCode = null;
            CodedValueType destCode = null;
            CodedValueType subsetCode = null;
            CodedValueType rCode = null;
            CodedValueType tranType = null;
            importcode = CodedValueFactory.getCodedValueType((int)1);
            sourceCode = CodedValueFactory.getCodedValueType((int)2);
            destCode = CodedValueFactory.getCodedValueType((int)3);
            patientNumCode = CodedValueFactory.getCodedValueType((int)4);
            pnrCode = CodedValueFactory.getCodedValueType((int)5);
            subsetCode = CodedValueFactory.getCodedValueType((int)6);
            rCode = CodedValueFactory.getCodedValueType((int)7);
            tranType = pnrCode;
            EventIdentificationType eit = new EventIdentificationType();
            eit.setEventID(importcode);
            eit.getEventTypeCode().add(tranType);
            eit.setEventActionCode("C");
            am.setEventIdentification(eit);
            List apts = am.getActiveParticipant();
            ActiveParticipantType source = new ActiveParticipantType();
            source.setUserID(replyTo);
            source.setUserIsRequestor(Boolean.TRUE);
            source.getRoleIDCode().add(sourceCode);
            source.setNetworkAccessPointTypeCode(this.VAL2);
            source.setNetworkAccessPointID(sourceName);
            apts.add(source);
            ActiveParticipantType destination = new ActiveParticipantType();
            destination.setUserID(to);
            destination.setAlternativeUserID(pid);
            destination.setUserIsRequestor(Boolean.FALSE);
            destination.getRoleIDCode().add(destCode);
            destination.setNetworkAccessPointTypeCode(this.VAL2);
            destination.setNetworkAccessPointID(thisName);
            apts.add(destination);
            List poits = am.getParticipantObjectIdentification();
            ParticipantObjectIdentificationType patient = new ParticipantObjectIdentificationType();
            patient.setParticipantObjectTypeCode(this.VAL1);
            patient.setParticipantObjectTypeCodeRole(this.VAL1);
            patient.setParticipantObjectIDTypeCode(patientNumCode);
            patient.setParticipantObjectID(patientId);
            poits.add(patient);
            ParticipantObjectIdentificationType subset = new ParticipantObjectIdentificationType();
            subset.setParticipantObjectTypeCode(this.VAL2);
            subset.setParticipantObjectTypeCodeRole(this.VAL20);
            subset.setParticipantObjectIDTypeCode(subsetCode);
            subset.setParticipantObjectID(subsetId);
            poits.add(subset);
            QName messName = new QName("http://www.xml.org/xml/schema/7f0d86bd/healthcare-security-audit", "AuditMessage");
            String message = AuditMessageGenerator.marshal((QName)messName, (Object)am, ObjectFactory.class);
            System.out.println(message);
            this.outputMessage(message);
        }
        catch (Exception x) {
            x.printStackTrace();
            throw x;
        }
    }

    public void provideAndRegisterAuditSource(String sourceMessageId, String sourceName, String replyTo, String to, String thisName, String patientId, String subsetId, String pid) throws Exception {
        try {
            AuditMessage am = new AuditMessage();
            CodedValueType exportcode = null;
            CodedValueType sourceCode = null;
            CodedValueType pnrCode = null;
            CodedValueType patientNumCode = null;
            CodedValueType destCode = null;
            CodedValueType subsetCode = null;
            CodedValueType tranType = null;
            exportcode = CodedValueFactory.getCodedValueType((int)10);
            sourceCode = CodedValueFactory.getCodedValueType((int)2);
            destCode = CodedValueFactory.getCodedValueType((int)3);
            patientNumCode = CodedValueFactory.getCodedValueType((int)4);
            pnrCode = CodedValueFactory.getCodedValueType((int)5);
            subsetCode = CodedValueFactory.getCodedValueType((int)6);
            tranType = pnrCode;
            EventIdentificationType eit = new EventIdentificationType();
            eit.setEventID(exportcode);
            eit.getEventTypeCode().add(tranType);
            eit.setEventActionCode("R");
            am.setEventIdentification(eit);
            List apts = am.getActiveParticipant();
            ActiveParticipantType source = new ActiveParticipantType();
            source.setUserID(replyTo);
            source.setUserIsRequestor(Boolean.TRUE);
            source.getRoleIDCode().add(sourceCode);
            source.setNetworkAccessPointTypeCode(this.VAL2);
            source.setNetworkAccessPointID(sourceName);
            apts.add(source);
            ActiveParticipantType destination = new ActiveParticipantType();
            destination.setUserID(to);
            destination.setAlternativeUserID(pid);
            destination.setUserIsRequestor(Boolean.FALSE);
            destination.getRoleIDCode().add(destCode);
            destination.setNetworkAccessPointTypeCode(this.VAL2);
            destination.setNetworkAccessPointID(thisName);
            apts.add(destination);
            List poits = am.getParticipantObjectIdentification();
            ParticipantObjectIdentificationType patient = new ParticipantObjectIdentificationType();
            patient.setParticipantObjectTypeCode(this.VAL1);
            patient.setParticipantObjectTypeCodeRole(this.VAL1);
            patient.setParticipantObjectIDTypeCode(patientNumCode);
            patient.setParticipantObjectID(patientId);
            poits.add(patient);
            ParticipantObjectIdentificationType subset = new ParticipantObjectIdentificationType();
            subset.setParticipantObjectTypeCode(this.VAL2);
            subset.setParticipantObjectTypeCodeRole(this.VAL20);
            subset.setParticipantObjectIDTypeCode(subsetCode);
            subset.setParticipantObjectID(subsetId);
            poits.add(subset);
            QName messName = new QName("http://www.xml.org/xml/schema/7f0d86bd/healthcare-security-audit", "AuditMessage");
            String message = AuditMessageGenerator.marshal((QName)messName, (Object)am, ObjectFactory.class);
            System.out.println(message);
            this.outputMessage(message);
        }
        catch (Exception x) {
            x.printStackTrace();
            throw x;
        }
    }

    private void outputMessage(String message) throws Exception {
        String newLine = "\r\n";
        if (this.auditMethod.equals((Object)AuditMethodEnum.SYSLOG)) {
            SyslogClient sc = new SyslogClient(this.auditHost, this.auditPort);
            sc.sendMessage(message);
        } else if (this.auditMethod.equals((Object)AuditMethodEnum.FILE)) {
            if (this.auditFile == null) {
                throw new Exception("No Filename Foud for audit log");
            }
            FileOutputStream fos = new FileOutputStream(this.auditFile, true);
            fos.write(message.getBytes());
            fos.write(newLine.getBytes());
            fos.close();
        }
    }

    private static String marshal(QName altName, Object jaxb, Class<?> factory) {
        String ret = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{factory});
            Marshaller u = jc.createMarshaller();
            StringWriter sw = new StringWriter();
            u.marshal((Object)new JAXBElement(altName, jaxb.getClass(), jaxb), (Writer)sw);
            StringBuffer sb = sw.getBuffer();
            ret = new String(sb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Failed to marshal message.");
        }
        return ret;
    }
}

