/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.xdm.impl;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.nhind.xdm.MimeSendClient;
import org.nhindirect.xd.common.DirectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSendClient
implements MimeSendClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractSendClient.class);

    public MimeMessage buildMimeMessage(DirectMessage message, String messageId, String suffix, Session session) throws MessagingException {
        MimeBodyPart mimeAttach;
        log.info("Building Mime message for sender.");
        InternetAddress addressFrom = new InternetAddress(message.getSender());
        InternetAddress[] addressTo = new InternetAddress[message.getReceivers().size()];
        int i = 0;
        for (String recipient : message.getReceivers()) {
            addressTo[i++] = new InternetAddress(recipient);
        }
        MimeMessage mmessage = new MimeMessage(session);
        mmessage.setFrom((Address)addressFrom);
        mmessage.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
        mmessage.setSubject(message.getSubject());
        MimeMultipart mailBody = new MimeMultipart();
        MimeBodyPart mainBody = new MimeBodyPart();
        mainBody.setDataHandler(new DataHandler((Object)message.getBody(), "text/plain"));
        mailBody.addBodyPart((BodyPart)mainBody);
        try {
            mimeAttach = new MimeBodyPart();
            mimeAttach.attachFile(message.getDirectDocuments().toXdmPackage(messageId).toFile());
        }
        catch (IOException e) {
            throw new MessagingException("Unable to create/attach xdm zip file", (Exception)e);
        }
        mailBody.addBodyPart((BodyPart)mimeAttach);
        mmessage.setContent((Multipart)mailBody);
        return mmessage;
    }
}

