/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.xdr;

import com.gsihealth.auditclient.AuditMessageGenerator;
import com.gsihealth.auditclient.type.AuditMethodEnum;
import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.Resource;
import javax.mail.util.ByteArrayDataSource;
import javax.naming.InitialContext;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.HandlerResolver;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryError;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryResponseType;
import org.apache.commons.lang3.StringUtils;
import org.nhind.config.rest.AddressService;
import org.nhind.config.rest.SettingService;
import org.nhind.xdm.impl.SmtpSendClient;
import org.nhind.xdm.impl.StreamsSendClient;
import org.nhind.xdr.config.XdConfig;
import org.nhindirect.xd.common.DirectDocuments;
import org.nhindirect.xd.common.DirectMessage;
import org.nhindirect.xd.proxy.DocumentRepositoryProxy;
import org.nhindirect.xd.routing.RoutingResolver;
import org.nhindirect.xd.routing.impl.RoutingResolverImpl;
import org.nhindirect.xd.soap.DirectSOAPHandlerResolver;
import org.nhindirect.xd.soap.SafeThreadData;
import org.nhindirect.xd.transform.XdsDirectDocumentsTransformer;
import org.nhindirect.xd.transform.impl.DefaultXdsDirectDocumentsTransformer;
import org.nhindirect.xd.transform.parse.ParserHL7;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class DocumentRepositoryAbstract {
    private static final Logger log = LoggerFactory.getLogger(DocumentRepositoryAbstract.class);
    @Resource
    protected WebServiceContext context;
    @Autowired
    protected AddressService addressService;
    @Autowired
    protected SettingService settingService;
    @Value(value="${direct.xd.usestreams:false}")
    protected boolean useStreams;
    @Autowired(required=false)
    protected StreamsSendClient streamsSendClient;
    private XdConfig config = null;
    private RoutingResolver resolver = null;
    private AuditMessageGenerator auditMessageGenerator = null;
    private XdsDirectDocumentsTransformer xdsDirectDocumentsTransformer = new DefaultXdsDirectDocumentsTransformer();

    public abstract RegistryResponseType documentRepositoryProvideAndRegisterDocumentSetB(ProvideAndRegisterDocumentSetRequestType var1);

    public abstract RetrieveDocumentSetResponseType documentRepositoryRetrieveDocumentSet(RetrieveDocumentSetRequestType var1);

    protected RegistryResponseType provideAndRegisterDocumentSet(ProvideAndRegisterDocumentSetRequestType prdst, SafeThreadData threadData) throws Exception {
        RegistryResponseType resp = null;
        try {
            InitialContext ctx = new InitialContext();
            DirectDocuments documents = this.xdsDirectDocumentsTransformer.transform(prdst);
            List<Object> forwards = new ArrayList();
            forwards = StringUtils.isNotBlank((CharSequence)threadData.getDirectTo()) ? Arrays.asList(new URI(threadData.getDirectTo()).getSchemeSpecificPart()) : ParserHL7.parseDirectRecipients((DirectDocuments)documents);
            String patId = threadData.getMessageId();
            String subsetId = threadData.getMessageId();
            this.getAuditMessageGenerator().provideAndRegisterAudit(threadData.getMessageId(), threadData.getRemoteHost(), threadData.getRelatesTo(), threadData.getTo(), threadData.getThisHost(), patId, subsetId, threadData.getPid());
            if (this.getResolver().hasSmtpEndpoints(forwards)) {
                String replyEmail;
                if (StringUtils.isNotBlank((CharSequence)threadData.getDirectFrom())) {
                    replyEmail = new URI(threadData.getDirectFrom()).getSchemeSpecificPart();
                } else {
                    replyEmail = documents.getSubmissionSet().getAuthorTelecommunication();
                    replyEmail = StringUtils.contains((CharSequence)(replyEmail = ParserHL7.parseXTN((String)replyEmail)), (CharSequence)"@") ? replyEmail : "nhindirect@nhindirect.org";
                }
                log.info("SENDING EMAIL TO " + this.getResolver().getSmtpEndpoints(forwards) + " with message id " + threadData.getMessageId());
                DirectMessage message = new DirectMessage(replyEmail, this.getResolver().getSmtpEndpoints(forwards));
                message.setSubject("XD* Originated Message");
                message.setBody("Please find the attached XDM file.");
                message.setDirectDocuments(documents);
                String fileName = threadData.getMessageId().replaceAll("urn:uuid:", "");
                if (this.useStreams && this.streamsSendClient != null) {
                    this.streamsSendClient.send(message, fileName, threadData.getSuffix());
                } else {
                    SmtpSendClient mailClient = this.getMailClient();
                    mailClient.send(message, fileName, threadData.getSuffix());
                }
                this.getAuditMessageGenerator().provideAndRegisterAuditSource(threadData.getMessageId(), threadData.getRemoteHost(), threadData.getRelatesTo(), threadData.getTo(), threadData.getThisHost(), patId, subsetId, threadData.getPid());
            }
            for (String reqEndpoint : this.getResolver().getXdEndpoints(forwards)) {
                String endpointUrl = this.getResolver().resolve(reqEndpoint);
                String to = StringUtils.remove((String)endpointUrl, (String)"?wsdl");
                threadData.setTo(to);
                threadData.setDirectTo(to);
                threadData.save();
                List docs = prdst.getDocument();
                ArrayList<ProvideAndRegisterDocumentSetRequestType.Document> originalDocs = new ArrayList<ProvideAndRegisterDocumentSetRequestType.Document>();
                for (ProvideAndRegisterDocumentSetRequestType.Document d : docs) {
                    originalDocs.add(d);
                }
                docs.clear();
                for (ProvideAndRegisterDocumentSetRequestType.Document d : originalDocs) {
                    ProvideAndRegisterDocumentSetRequestType.Document doc = new ProvideAndRegisterDocumentSetRequestType.Document();
                    doc.setId(d.getId());
                    DataHandler dh = d.getValue();
                    ByteArrayOutputStream buffOS = new ByteArrayOutputStream();
                    dh.writeTo((OutputStream)buffOS);
                    byte[] buff = buffOS.toByteArray();
                    ByteArrayDataSource source = new ByteArrayDataSource(buff, documents.getDocument(d.getId()).getMetadata().getMimeType());
                    DataHandler dhnew = new DataHandler((DataSource)source);
                    doc.setValue(dhnew);
                    docs.add(doc);
                }
                log.info(" SENDING TO ENDPOINT " + to);
                DocumentRepositoryProxy proxy = new DocumentRepositoryProxy(endpointUrl, (HandlerResolver)new DirectSOAPHandlerResolver());
                RegistryResponseType rrt = proxy.provideAndRegisterDocumentSetB(prdst);
                String test = rrt.getStatus();
                if (test.indexOf("Failure") >= 0) {
                    String error = "";
                    try {
                        error = ((RegistryError)rrt.getRegistryErrorList().getRegistryError().get(0)).getCodeContext();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new Exception("Failure Returned from XDR forward:" + error);
                }
                this.getAuditMessageGenerator().provideAndRegisterAuditSource(threadData.getMessageId(), threadData.getRemoteHost(), threadData.getRelatesTo(), threadData.getTo(), threadData.getThisHost(), patId, subsetId, threadData.getPid());
            }
            resp = this.getRepositoryProvideResponse(threadData.getMessageId());
            threadData.setRelatesTo(threadData.getMessageId());
            threadData.setAction("urn:ihe:iti:2007:ProvideAndRegisterDocumentSet-bResponse");
            threadData.setTo(null);
            threadData.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return resp;
    }

    protected RegistryResponseType getRepositoryProvideResponse(String messageId) throws Exception {
        RegistryResponseType rrt = null;
        try {
            String status = "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success";
            try {
                rrt = new RegistryResponseType();
                rrt.setStatus(status);
            }
            catch (Exception ex) {
                log.info("not sure what this ");
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rrt;
    }

    private RoutingResolver getResolver() {
        if (this.resolver == null) {
            if (this.addressService != null) {
                try {
                    this.resolver = new RoutingResolverImpl(this.addressService);
                    this.config = new XdConfig(this.settingService);
                }
                catch (Exception e) {
                    log.warn("Unable to create resolver from URL, falling back to default");
                    this.resolver = new RoutingResolverImpl();
                }
            } else {
                this.resolver = new RoutingResolverImpl();
            }
        }
        return this.resolver;
    }

    private AuditMessageGenerator getAuditMessageGenerator() {
        if (this.auditMessageGenerator == null) {
            String auditMethod;
            if (this.config == null) {
                this.config = this.getConfig();
            }
            if (StringUtils.equals((CharSequence)(auditMethod = this.config.getAuditMethod()), (CharSequence)AuditMethodEnum.SYSLOG.getMethod())) {
                String auditHost = this.config.getAuditHost();
                String auditPort = this.config.getAuditPort();
                this.auditMessageGenerator = new AuditMessageGenerator(auditHost, auditPort);
            } else if (StringUtils.equals((CharSequence)auditMethod, (CharSequence)AuditMethodEnum.FILE.getMethod())) {
                String fileName = this.config.getAuditFile();
                this.auditMessageGenerator = new AuditMessageGenerator(fileName);
            } else {
                throw new IllegalArgumentException("Unknown audit method.");
            }
        }
        return this.auditMessageGenerator;
    }

    private SmtpSendClient getMailClient() {
        if (this.config == null) {
            this.config = this.getConfig();
        }
        String hostname = this.config.getMailHost();
        String username = this.config.getMailUser();
        String password = this.config.getMailPass();
        return new SmtpSendClient(hostname, username, password);
    }

    private XdConfig getConfig() {
        XdConfig lconfig = null;
        if (this.settingService != null) {
            try {
                lconfig = new XdConfig(this.settingService);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create config from setting service", e);
            }
        } else {
            throw new RuntimeException("setting service URL is null");
        }
        return lconfig;
    }

    public void setConfig(XdConfig config) {
        this.config = config;
    }

    public void setAuditMessageGenerator(AuditMessageGenerator auditMessageGenerator) {
        this.auditMessageGenerator = auditMessageGenerator;
    }

    public void setResolver(RoutingResolver resolver) {
        this.resolver = resolver;
    }
}

