/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.xdr.config;

import org.nhind.config.rest.SettingService;
import org.nhind.xdr.config.XdConfig;
import org.nhindirect.config.model.Setting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XdConfig {
    private static final Logger log = LoggerFactory.getLogger(XdConfig.class);
    protected SettingService settingService;
    private String mailHost;
    private String mailUser;
    private String mailPass;
    private String auditMethod;
    private String auditHost;
    private String auditPort;
    private String auditFile;

    public XdConfig() {
        this.init();
    }

    public XdConfig(SettingService settingService) {
        this.settingService = settingService;
        this.init();
    }

    public void init() {
        if (this.settingService == null) {
            return;
        }
        try {
            this.mailHost = this.getValue(Settings.MAIL_HOST);
            this.mailUser = this.getValue(Settings.MAIL_USER);
            this.mailPass = this.getValue(Settings.MAIL_PASS);
            this.auditMethod = this.getValue(Settings.AUDIT_METHOD);
            this.auditHost = this.getValue(Settings.AUDIT_HOST);
            this.auditPort = this.getValue(Settings.AUDIT_PORT);
            this.auditFile = this.getValue(Settings.AUDIT_FILE);
        }
        catch (Exception e) {
            log.error("Error initializing the XD configuration");
        }
    }

    private String getValue(Settings xdSetting) throws Exception {
        String value = null;
        if (this.settingService != null) {
            try {
                Setting tmp = this.settingService.getSetting(xdSetting.getKey());
                value = tmp != null ? tmp.getValue() : xdSetting.getDefault();
            }
            catch (Exception e) {
                log.warn("Could not find configured value for " + xdSetting.getKey() + ".  Defaulting to " + xdSetting.getDefault());
                value = xdSetting.getDefault();
            }
        }
        return value;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public void setMailHost(String mailHost) {
        this.mailHost = mailHost;
    }

    public String getMailUser() {
        return this.mailUser;
    }

    public void setMailUser(String mailUser) {
        this.mailUser = mailUser;
    }

    public String getMailPass() {
        return this.mailPass;
    }

    public void setMailPass(String mailPass) {
        this.mailPass = mailPass;
    }

    public String getAuditMethod() {
        return this.auditMethod;
    }

    public void setAuditMethod(String auditMethod) {
        this.auditMethod = auditMethod;
    }

    public String getAuditHost() {
        return this.auditHost;
    }

    public void setAuditHost(String auditHost) {
        this.auditHost = auditHost;
    }

    public String getAuditPort() {
        return this.auditPort;
    }

    public void setAuditPort(String auditPort) {
        this.auditPort = auditPort;
    }

    public String getAuditFile() {
        return this.auditFile;
    }

    public void setAuditFile(String auditFile) {
        this.auditFile = auditFile;
    }

    public SettingService getSettingService() {
        return this.settingService;
    }

    public void setSettingService(SettingService settingService) {
        this.settingService = settingService;
    }
}

