/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.james.mailet;

import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import java.util.ArrayList;
import java.util.Collection;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;
import org.nhind.mail.service.DocumentRepository;
import org.nhindirect.xd.routing.RoutingResolver;
import org.nhindirect.xd.routing.impl.RoutingResolverImpl;
import org.nhindirect.xd.transform.MimeXdsTransformer;
import org.nhindirect.xd.transform.impl.DefaultMimeXdsTransformer;

public class DirectXdMailet
extends GenericMailet {
    private String endpointUrl;
    private String configServiceUrl;
    private MimeXdsTransformer mimeXDSTransformer;
    private DocumentRepository documentRepository;
    private RoutingResolver resolver;
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DirectXdMailet.class);

    public void service(Mail mail) throws MessagingException {
        LOGGER.info((Object)"Servicing DirectXdMailet");
        if (StringUtils.isBlank((String)this.endpointUrl)) {
            LOGGER.error((Object)"DirectXdMailet endpoint URL cannot be empty or null.");
            throw new MessagingException("DirectXdMailet endpoint URL cannot be empty or null.");
        }
        ArrayList<String> recipAddresses = new ArrayList<String>();
        for (Object addr : mail.getRecipients()) {
            recipAddresses.add(((MailAddress)addr).toString());
        }
        if (this.getResolver().hasXdEndpoints(recipAddresses)) {
            LOGGER.info((Object)"Recipients include XD endpoints");
            try {
                ArrayList<InternetAddress> xdAddresses = new ArrayList<InternetAddress>();
                for (String s : this.getResolver().getXdEndpoints(recipAddresses)) {
                    xdAddresses.add(new MailAddress(s).toInternetAddress());
                }
                mail.getMessage().setRecipients(Message.RecipientType.TO, xdAddresses.toArray(new Address[0]));
                ProvideAndRegisterDocumentSetRequestType request = this.getMimeXDSTransformer().transform(mail.getMessage());
                for (String directTo : recipAddresses) {
                    String response = this.getDocumentRepository().forwardRequest(this.endpointUrl, request, directTo, mail.getSender().toString());
                    if (this.isSuccessful(response)) continue;
                    LOGGER.error((Object)"DirectXdMailet failed to deliver XD message.");
                    LOGGER.error((Object)response);
                }
            }
            catch (Throwable e) {
                LOGGER.error((Object)"DirectXdMailet delivery failure", e);
            }
        }
        if (this.getResolver().hasSmtpEndpoints(recipAddresses)) {
            LOGGER.info((Object)"Recipients include SMTP endpoints");
            mail.setRecipients(this.getSmtpRecips(recipAddresses));
        } else {
            LOGGER.info((Object)"Recipients do not include SMTP endpoints");
            mail.setState("ghost");
        }
    }

    private Collection<MailAddress> getSmtpRecips(Collection<String> recips) throws AddressException {
        ArrayList<MailAddress> addrs = new ArrayList<MailAddress>();
        for (String s : this.getResolver().getSmtpEndpoints(recips)) {
            addrs.add(new MailAddress(s));
        }
        return addrs;
    }

    private boolean isSuccessful(String response) {
        return !StringUtils.contains((String)response, (String)"Failure");
    }

    public void init() throws MessagingException {
        LOGGER.info((Object)"Initializing DirectXdMailet");
        this.endpointUrl = this.getInitParameter("EndpointURL");
        if (StringUtils.isBlank((String)this.endpointUrl)) {
            LOGGER.error((Object)"DirectXdMailet endpoint URL cannot be empty or null.");
            throw new MessagingException("DirectXdMailet endpoint URL cannot be empty or null.");
        }
        try {
            this.configServiceUrl = this.getInitParameter("ConfigURL");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getEndpointUrl() {
        return this.endpointUrl;
    }

    protected void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    protected String getConfigServiceUrl() {
        return this.configServiceUrl;
    }

    protected void setConfigServiceUrl(String configServiceUrl) {
        this.configServiceUrl = configServiceUrl;
    }

    protected void setResolver(RoutingResolver resolver) {
        this.resolver = resolver;
    }

    protected RoutingResolver getResolver() {
        if (this.resolver == null) {
            this.resolver = new RoutingResolverImpl(this.configServiceUrl);
        }
        return this.resolver;
    }

    protected void setMimeXDSTransformer(MimeXdsTransformer mimeXDSTransformer) {
        this.mimeXDSTransformer = mimeXDSTransformer;
    }

    protected MimeXdsTransformer getMimeXDSTransformer() {
        if (this.mimeXDSTransformer == null) {
            this.mimeXDSTransformer = new DefaultMimeXdsTransformer();
        }
        return this.mimeXDSTransformer;
    }

    public void setDocumentRepository(DocumentRepository documentRepository) {
        this.documentRepository = documentRepository;
    }

    public DocumentRepository getDocumentRepository() {
        if (this.documentRepository == null) {
            this.documentRepository = new DocumentRepository();
        }
        return this.documentRepository;
    }
}

