/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.mail.service;

import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import java.util.UUID;
import javax.xml.ws.handler.HandlerResolver;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryResponseType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.xd.proxy.DocumentRepositoryProxy;
import org.nhindirect.xd.soap.DirectSOAPHandlerResolver;
import org.nhindirect.xd.soap.ThreadData;

public class DocumentRepository {
    private String to = null;
    private String action = null;
    private String messageId = null;
    private String directTo = null;
    private String directFrom = null;
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DocumentRepository.class);

    public String forwardRequest(String endpoint, ProvideAndRegisterDocumentSetRequestType prds, String directTo, String directFrom) throws Exception {
        if (StringUtils.isBlank((String)endpoint)) {
            throw new IllegalArgumentException("Endpoint must not be blank");
        }
        if (prds == null) {
            throw new IllegalArgumentException("ProvideAndRegisterDocumentSetRequestType must not be null");
        }
        LOGGER.info((Object)(" SENDING TO ENDPOINT " + endpoint));
        this.action = "urn:ihe:iti:2007:ProvideAndRegisterDocumentSet-b";
        this.messageId = UUID.randomUUID().toString();
        this.to = endpoint;
        this.directTo = directTo;
        this.directFrom = directFrom;
        this.setHeaderData();
        DocumentRepositoryProxy proxy = new DocumentRepositoryProxy(endpoint, (HandlerResolver)new DirectSOAPHandlerResolver());
        RegistryResponseType rrt = proxy.provideAndRegisterDocumentSetB(prds);
        String response = rrt.getStatus();
        if (StringUtils.contains((String)response, (String)"Failure")) {
            throw new Exception("Failure Returned from XDR forward");
        }
        LOGGER.info((Object)"Handling complete");
        return response;
    }

    protected void setHeaderData() {
        Long threadId = Thread.currentThread().getId();
        LOGGER.info((Object)("THREAD ID " + threadId));
        ThreadData threadData = new ThreadData(threadId);
        threadData.setTo(this.to);
        threadData.setMessageId(this.messageId);
        threadData.setAction(this.action);
        threadData.setDirectTo(this.directTo);
        threadData.setDirectFrom(this.directFrom);
        LOGGER.info((Object)threadData.toString());
    }
}

