/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.mail.service;

import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import java.util.UUID;
import javax.xml.ws.handler.HandlerResolver;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryResponseType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.xd.proxy.DocumentRepositoryProxy;
import org.nhindirect.xd.soap.DirectSOAPHandlerResolver;
import org.nhindirect.xd.soap.SafeThreadData;

public class DocumentRepository {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DocumentRepository.class);

    public String forwardRequest(String endpoint, ProvideAndRegisterDocumentSetRequestType prds, String directTo, String directFrom) throws Exception {
        if (StringUtils.isBlank((String)endpoint)) {
            throw new IllegalArgumentException("Endpoint must not be blank");
        }
        if (prds == null) {
            throw new IllegalArgumentException("ProvideAndRegisterDocumentSetRequestType must not be null");
        }
        LOGGER.info((Object)(" SENDING TO ENDPOINT " + endpoint));
        Long threadID = Thread.currentThread().getId();
        SafeThreadData threadData = SafeThreadData.GetThreadInstance((Long)threadID);
        threadData.setAction("urn:ihe:iti:2007:ProvideAndRegisterDocumentSet-b");
        threadData.setMessageId(UUID.randomUUID().toString());
        threadData.setTo(endpoint);
        threadData.setDirectFrom(directFrom);
        threadData.setDirectTo(directTo);
        threadData.save();
        DocumentRepositoryProxy proxy = new DocumentRepositoryProxy(endpoint, (HandlerResolver)new DirectSOAPHandlerResolver());
        try {
            RegistryResponseType rrt = proxy.provideAndRegisterDocumentSetB(prds);
            String response = rrt.getStatus();
            if (StringUtils.contains((String)response, (String)"Failure")) {
                throw new Exception("Failure Returned from XDR forward");
            }
            SafeThreadData.clean((Long)threadID);
            LOGGER.info((Object)"Handling complete");
            return response;
        }
        catch (Exception ex) {
            SafeThreadData.clean((Long)threadID);
            throw ex;
        }
    }
}

