/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.james.mailet;

import java.util.ArrayList;
import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.nhind.config.rest.AddressService;
import org.nhind.mail.service.DocumentRepository;
import org.nhind.mail.service.XDDeliveryCallback;
import org.nhind.mail.service.XDDeliveryCore;
import org.nhindirect.common.mail.SMTPMailMessage;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.gateway.smtp.NotificationProducer;
import org.nhindirect.gateway.smtp.NotificationSettings;
import org.nhindirect.gateway.smtp.ReliableDispatchedNotificationProducer;
import org.nhindirect.gateway.smtp.dsn.DSNCreator;
import org.nhindirect.gateway.smtp.dsn.impl.FailedDeliveryDSNCreator;
import org.nhindirect.gateway.smtp.james.mailet.AbstractNotificationAwareMailet;
import org.nhindirect.gateway.util.MessageUtils;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.nhindirect.xd.routing.RoutingResolver;
import org.nhindirect.xd.routing.impl.RoutingResolverImpl;
import org.nhindirect.xd.transform.MimeXdsTransformer;
import org.nhindirect.xd.transform.impl.DefaultMimeXdsTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DirectXdMailet
extends AbstractNotificationAwareMailet
implements XDDeliveryCallback {
    protected static final String RELIABLE_DELIVERY_OPTION = "X-DIRECT-FINAL-DESTINATION-DELIVERY=optional,true";
    private String endpointUrl;
    private MimeXdsTransformer mimeXDSTransformer;
    private DocumentRepository documentRepository;
    private RoutingResolver resolver;
    private XDDeliveryCore deliveryCore;
    protected NotificationProducer notificationProducer;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectXdMailet.class);

    public void service(Mail mail) throws MessagingException {
        LOGGER.info("Servicing DirectXdMailet");
        SMTPMailMessage smtpMailMessage = DirectXdMailet.mailToSMTPMailMessage((Mail)mail);
        NHINDAddressCollection initialRecipients = MessageUtils.getMailRecipients((SMTPMailMessage)smtpMailMessage);
        this.deliveryCore.processAndDeliverXDMessage(smtpMailMessage);
        ArrayList<String> recipAddresses = new ArrayList<String>();
        for (NHINDAddress addr : initialRecipients) {
            recipAddresses.add(addr.getAddress());
        }
        if (this.getResolver().hasSmtpEndpoints(recipAddresses)) {
            LOGGER.info("Recipients include SMTP endpoints");
            mail.setRecipients(this.getSmtpRecips(recipAddresses));
        } else {
            LOGGER.info("Recipients do not include SMTP endpoints");
            mail.setState("ghost");
        }
    }

    private Collection<MailAddress> getSmtpRecips(Collection<String> recips) throws AddressException, MessagingException {
        ArrayList<MailAddress> addrs = new ArrayList<MailAddress>();
        for (String s : this.getResolver().getSmtpEndpoints(recips)) {
            addrs.add(new MailAddress(s));
        }
        return addrs;
    }

    public void init() throws MessagingException {
        LOGGER.info("Initializing DirectXdMailet");
        super.init();
        this.endpointUrl = this.getInitParameter("EndpointURL");
        if (StringUtils.isBlank((CharSequence)this.endpointUrl)) {
            LOGGER.error("DirectXdMailet endpoint URL cannot be empty or null.");
            throw new MessagingException("DirectXdMailet endpoint URL cannot be empty or null.");
        }
        this.notificationProducer = new ReliableDispatchedNotificationProducer(new NotificationSettings(true, "Direct XD Delivery Agent", "Your message was successfully dispatched."));
        this.deliveryCore = new XDDeliveryCore(this.getResolver(), this, this.txParser, this.getMimeXDSTransformer(), this.getDocumentRepository(), this.notificationProducer, this.endpointUrl);
    }

    protected ApplicationContext createSpringApplicationContext() {
        return new ClassPathXmlApplicationContext("contexts/XDMailet.xml");
    }

    protected String getEndpointUrl() {
        return this.endpointUrl;
    }

    protected void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    protected void setResolver(RoutingResolver resolver) {
        this.resolver = resolver;
    }

    protected RoutingResolver getResolver() throws MessagingException {
        if (this.ctx == null) {
            throw new MessagingException("Spring Application Context is null");
        }
        if (this.resolver == null) {
            this.resolver = new RoutingResolverImpl((AddressService)this.ctx.getBean(AddressService.class));
        }
        return this.resolver;
    }

    protected void setMimeXDSTransformer(MimeXdsTransformer mimeXDSTransformer) {
        this.mimeXDSTransformer = mimeXDSTransformer;
    }

    protected MimeXdsTransformer getMimeXDSTransformer() {
        if (this.mimeXDSTransformer == null) {
            this.mimeXDSTransformer = new DefaultMimeXdsTransformer();
        }
        return this.mimeXDSTransformer;
    }

    public void setDocumentRepository(DocumentRepository documentRepository) {
        this.documentRepository = documentRepository;
    }

    public DocumentRepository getDocumentRepository() {
        if (this.documentRepository == null) {
            this.documentRepository = new DocumentRepository();
        }
        return this.documentRepository;
    }

    protected DSNCreator createDSNGenerator() {
        return new FailedDeliveryDSNCreator((Mailet)this);
    }

    @Override
    public void sendNotificationMessage(NotificationMessage message) throws MessagingException {
        try {
            this.getMailetContext().sendMail((MimeMessage)message);
        }
        catch (Throwable t) {
            LOGGER.error("Error sending MDN dispatched message.", t);
        }
    }

    @Override
    public void sendFailureMessage(Tx tx, NHINDAddressCollection undeliveredRecipeints, boolean useSenderAsPostmaster) throws MessagingException {
        this.sendDSN(tx, undeliveredRecipeints, false);
    }
}

