/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.james.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.nhind.config.rest.AddressService;
import org.nhindirect.xd.routing.RoutingResolver;
import org.nhindirect.xd.routing.impl.RoutingResolverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class RecipientIsXdAndNotSMIME
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecipientIsXdAndNotSMIME.class);
    private RoutingResolver routingResolver;
    protected ApplicationContext ctx;

    public void init() {
        LOGGER.info("Initializing RecipientIsXdAndNotSMIME matcher");
        this.ctx = new ClassPathXmlApplicationContext("contexts/XDMailet.xml");
        this.routingResolver = new RoutingResolverImpl((AddressService)this.ctx.getBean(AddressService.class));
        LOGGER.info("Initialized RecipientIsXdAndNotSMIME matcher");
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        LOGGER.info("Attempting to match XD recipients");
        ArrayList<MailAddress> recipients = new ArrayList<MailAddress>();
        MimeMessage message = mail.getMessage();
        if (message.isMimeType("application/x-pkcs7-mime") || message.isMimeType("application/pkcs7-mime")) {
            LOGGER.info("MimeMessage is SMIME, skipping");
            return Collections.emptyList();
        }
        for (MailAddress addr : mail.getRecipients()) {
            if (!this.routingResolver.isXdEndpoint(addr.toString())) continue;
            recipients.add(addr);
        }
        if (recipients.isEmpty()) {
            LOGGER.info("Matched no recipients");
        } else {
            for (MailAddress addr : recipients) {
                LOGGER.info("Matched recipient " + addr.toString());
            }
        }
        return recipients;
    }
}

