/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.mail.service;

import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import java.util.ArrayList;
import java.util.Collection;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.nhind.mail.service.DocumentRepository;
import org.nhind.mail.service.XDDeliveryCallback;
import org.nhindirect.common.mail.SMTPMailMessage;
import org.nhindirect.common.tx.TxDetailParser;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.gateway.smtp.NotificationProducer;
import org.nhindirect.gateway.util.MessageUtils;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.nhindirect.xd.routing.RoutingResolver;
import org.nhindirect.xd.transform.MimeXdsTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XDDeliveryCore {
    private static final Logger LOGGER = LoggerFactory.getLogger(XDDeliveryCore.class);
    protected final RoutingResolver resolver;
    protected final XDDeliveryCallback callback;
    protected final TxDetailParser txParser;
    protected final MimeXdsTransformer mimeXDSTransformer;
    protected final DocumentRepository documentRepository;
    protected final NotificationProducer notificationProducer;
    protected final String endpointUrl;

    public XDDeliveryCore(RoutingResolver resolver, XDDeliveryCallback callback, TxDetailParser txParser, MimeXdsTransformer mimeXDSTransformer, DocumentRepository documentRepository, NotificationProducer notificationProducer, String endpointUrl) {
        this.resolver = resolver;
        this.callback = callback;
        this.txParser = txParser;
        this.mimeXDSTransformer = mimeXDSTransformer;
        this.endpointUrl = endpointUrl;
        this.documentRepository = documentRepository;
        this.notificationProducer = notificationProducer;
    }

    public boolean processAndDeliverXDMessage(SMTPMailMessage smtpMailMessage) throws MessagingException {
        LOGGER.info("Servicing process XD Message.");
        boolean successfulTransaction = false;
        boolean isReliableAndTimely = TxUtil.isReliableAndTimelyRequested((MimeMessage)smtpMailMessage.getMimeMessage());
        NHINDAddressCollection initialRecipients = MessageUtils.getMailRecipients((SMTPMailMessage)smtpMailMessage);
        NHINDAddressCollection xdRecipients = new NHINDAddressCollection();
        MimeMessage msg = smtpMailMessage.getMimeMessage();
        NHINDAddress sender = MessageUtils.getMailSender((SMTPMailMessage)smtpMailMessage);
        Tx txToTrack = null;
        ArrayList<String> recipAddresses = new ArrayList<String>();
        for (NHINDAddress addr : initialRecipients) {
            recipAddresses.add(addr.getAddress());
        }
        if (this.resolver.hasXdEndpoints(recipAddresses)) {
            LOGGER.info("Recipients include XD endpoints");
            try {
                for (String s : this.resolver.getXdEndpoints(recipAddresses)) {
                    xdRecipients.add((Object)new NHINDAddress(s));
                }
                txToTrack = MessageUtils.getTxToTrack((MimeMessage)msg, (NHINDAddress)sender, (NHINDAddressCollection)xdRecipients, (TxDetailParser)this.txParser);
                msg.setRecipients(Message.RecipientType.TO, (Address[])xdRecipients.toArray((Object[])new Address[0]));
                ProvideAndRegisterDocumentSetRequestType request = this.mimeXDSTransformer.transform(msg);
                for (String directTo : recipAddresses) {
                    Collection notifications;
                    String response = this.documentRepository.forwardRequest(this.endpointUrl, request, directTo, sender.toString());
                    if (!this.isSuccessful(response)) {
                        LOGGER.error("DirectXdMailet failed to deliver XD message.");
                        LOGGER.error(response);
                        continue;
                    }
                    successfulTransaction = true;
                    if (!isReliableAndTimely || txToTrack == null || txToTrack.getMsgType() != TxMessageType.IMF || (notifications = this.notificationProducer.produce(new Message(msg), xdRecipients.toInternetAddressCollection())) == null || notifications.size() <= 0) continue;
                    LOGGER.debug("Sending MDN \"dispathed\" messages");
                    for (NotificationMessage message : notifications) {
                        try {
                            this.callback.sendNotificationMessage(message);
                        }
                        catch (Throwable t) {
                            LOGGER.error("Error sending MDN dispatched message.", t);
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error("DirectXdMailet delivery failure", e);
            }
        }
        if (!successfulTransaction && txToTrack != null && txToTrack.getMsgType() == TxMessageType.IMF) {
            this.callback.sendFailureMessage(txToTrack, xdRecipients, false);
        }
        return successfulTransaction;
    }

    private boolean isSuccessful(String response) {
        return !StringUtils.contains((CharSequence)response, (CharSequence)"Failure");
    }
}

