/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.xd.streams.processors;

import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.nhind.mail.service.XDDeliveryCallback;
import org.nhind.mail.service.XDDeliveryCore;
import org.nhind.xd.streams.XDRemoteDeliveryInput;
import org.nhindirect.common.mail.SMTPMailMessage;
import org.nhindirect.common.mail.streams.SMTPMailMessageConverter;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.gateway.smtp.dsn.DSNCreator;
import org.nhindirect.gateway.streams.SmtpGatewayMessageSource;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.Message;

@EnableBinding(value={XDRemoteDeliveryInput.class})
public class XDRemoteDeliveryProcessor
implements XDDeliveryCallback {
    @Autowired
    protected XDDeliveryCore deliveryCore;
    @Autowired
    protected SmtpGatewayMessageSource smtpMessageSource;
    @Autowired
    protected DSNCreator dsnCreator;
    private static final Logger LOGGER = LoggerFactory.getLogger(XDRemoteDeliveryProcessor.class);

    @StreamListener(target="direct-xd-delivery-input")
    public void xdRemotelyDeliverMessage(Message<?> streamMsg) throws MessagingException {
        SMTPMailMessage smtpMessage = SMTPMailMessageConverter.fromStreamMessage(streamMsg);
        this.deliveryCore.processAndDeliverXDMessage(smtpMessage);
    }

    @Override
    public void sendNotificationMessage(NotificationMessage message) throws MessagingException {
        this.smtpMessageSource.sendMimeMessage((MimeMessage)message);
    }

    @Override
    public void sendFailureMessage(Tx tx, NHINDAddressCollection undeliveredRecipeints, boolean useSenderAsPostmaster) throws MessagingException {
        try {
            Collection msgs = this.dsnCreator.createDSNFailure(tx, undeliveredRecipeints, useSenderAsPostmaster);
            if (msgs != null && msgs.size() > 0) {
                for (MimeMessage msg : msgs) {
                    this.smtpMessageSource.sendMimeMessage(msg);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error sending DSN failure message.", e);
        }
    }
}

