/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.james.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.mail.MessagingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientIsLocalAndSMTPAuthUserIs
extends GenericMatcher {
    private static final Logger log = LoggerFactory.getLogger(RecipientIsLocalAndSMTPAuthUserIs.class);
    private static final String SMTP_AUTH_USER_ATTRIBUTE_NAME = "org.apache.james.SMTPAuthUser";
    private String user;

    public void init() throws MessagingException {
        this.user = this.getCondition();
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        log.info("Servicing RecipientIsLocalAndSMTPAuthUserIs matcher");
        String authUser = (String)((Object)mail.getAttribute(SMTP_AUTH_USER_ATTRIBUTE_NAME));
        if (authUser == null || !StringUtils.equalsIgnoreCase((CharSequence)this.user, (CharSequence)authUser)) {
            log.info("Auth user is not " + this.user + ", skipping");
            return Collections.emptyList();
        }
        MailetContext mailetContext = this.getMailetContext();
        ArrayList<MailAddress> recipients = new ArrayList<MailAddress>();
        for (MailAddress recipient : mail.getRecipients()) {
            if (!mailetContext.isLocalServer(recipient.getDomain()) || !mailetContext.isLocalEmail(recipient)) continue;
            recipients.add(recipient);
        }
        if (recipients.isEmpty()) {
            log.info("Matched no recipients");
        } else {
            for (MailAddress addr : recipients) {
                log.info("Matched recipient " + addr.toString());
            }
        }
        return recipients;
    }
}

