/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.xd.streams.processors;

import java.util.Collection;
import java.util.function.Consumer;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.nhind.mail.service.XDDeliveryCallback;
import org.nhind.mail.service.XDDeliveryCore;
import org.nhindirect.common.mail.SMTPMailMessage;
import org.nhindirect.common.mail.streams.SMTPMailMessageConverter;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.gateway.smtp.dsn.DSNCreator;
import org.nhindirect.gateway.streams.SmtpGatewayMessageSource;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.Message;

@Configuration
public class XDRemoteDeliveryProcessor
implements XDDeliveryCallback {
    private static final Logger log = LoggerFactory.getLogger(XDRemoteDeliveryProcessor.class);
    @Autowired
    protected XDDeliveryCore deliveryCore;
    @Autowired
    protected SmtpGatewayMessageSource smtpMessageSource;
    @Autowired
    protected DSNCreator dsnCreator;

    @Bean
    public Consumer<Message<?>> directXDDeliveryInput() {
        return streamMsg -> {
            try {
                SMTPMailMessage smtpMessage = SMTPMailMessageConverter.fromStreamMessage((Message)streamMsg);
                this.deliveryCore.processAndDeliverXDMessage(smtpMessage);
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public void sendNotificationMessage(NotificationMessage message) throws MessagingException {
        this.smtpMessageSource.sendMimeMessage((MimeMessage)message);
    }

    @Override
    public void sendFailureMessage(Tx tx, NHINDAddressCollection undeliveredRecipeints, boolean useSenderAsPostmaster) throws MessagingException {
        try {
            Collection msgs = this.dsnCreator.createDSNFailure(tx, undeliveredRecipeints, useSenderAsPostmaster);
            if (msgs != null && msgs.size() > 0) {
                for (MimeMessage msg : msgs) {
                    this.smtpMessageSource.sendMimeMessage(msg);
                }
            }
        }
        catch (Throwable e) {
            log.error("Error sending DSN failure message.", e);
        }
    }
}

