/*
 * Decompiled with CFR 0.152.
 */
package org.nicosoft.config.support.spring;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringBeanFactory
implements ApplicationContextAware,
BeanFactoryPostProcessor {
    ApplicationContext applicationContext;
    ConfigurableListableBeanFactory beanFactory;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void reloadBean(Class<?> clazz, String initMethod, String destroyMethod) throws Exception {
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)this.beanFactory;
        String beanName = clazz.getSimpleName().substring(0, 1).toLowerCase() + clazz.getSimpleName().substring(1);
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(clazz);
        beanDefinition.setAutowireCandidate(true);
        if (StringUtils.isNotBlank((CharSequence)initMethod)) {
            beanDefinition.setInitMethodName(initMethod);
        }
        if (StringUtils.isNotBlank((CharSequence)destroyMethod)) {
            beanDefinition.setDestroyMethodName(destroyMethod);
        }
        if (beanDefinitionRegistry.containsBeanDefinition(beanName)) {
            beanDefinitionRegistry.removeBeanDefinition(beanName);
        }
        beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        this.applicationContext.getBean(beanName);
    }
}

