/*
 * Decompiled with CFR 0.152.
 */
package org.nicosoft.config.support.utils;

public class Logger {
    private static org.apache.log4j.Logger log4j = org.apache.log4j.Logger.getLogger(Logger.class);

    static String format(String msg, Object ... args) {
        try {
            if (args != null && args.length > 0) {
                return String.format(msg, args);
            }
            return msg;
        }
        catch (Exception e) {
            return msg;
        }
    }

    static String getCallerClassName() {
        int level = 5;
        return Logger.getCallerClassName(5);
    }

    static String getCallerClassName(int level) {
        CallInfo ci = Logger.getCallerInformations(level);
        return ci.className;
    }

    static CallInfo getCallerInformations(int level) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        StackTraceElement caller = callStack[level];
        return new CallInfo(caller.getClassName(), caller.getMethodName());
    }

    public static void trace(String message, Object ... args) {
        try {
            org.apache.log4j.Logger.getLogger((String)Logger.getCallerClassName()).trace((Object)Logger.format(message, args));
        }
        catch (Throwable ex) {
            log4j.error((Object)"Oops. Error in Logger !", ex);
        }
    }

    public static void debug(String message, Object ... args) {
        try {
            org.apache.log4j.Logger.getLogger((String)Logger.getCallerClassName()).debug((Object)Logger.format(message, args));
        }
        catch (Throwable ex) {
            log4j.error((Object)"Oops. Error in Logger !", ex);
        }
    }

    public static void debug(Throwable e, String message, Object ... args) {
        try {
            org.apache.log4j.Logger.getLogger((String)Logger.getCallerClassName()).debug((Object)Logger.format(message, args), e);
        }
        catch (Throwable ex) {
            log4j.error((Object)"Oops. Error in Logger !", ex);
        }
    }

    public static void info(String message, Object ... args) {
        try {
            org.apache.log4j.Logger.getLogger((String)Logger.getCallerClassName()).info((Object)Logger.format(message, args));
        }
        catch (Throwable ex) {
            log4j.error((Object)"Oops. Error in Logger !", ex);
        }
    }

    public static void info(Throwable e, String message, Object ... args) {
        try {
            org.apache.log4j.Logger.getLogger((String)Logger.getCallerClassName()).info((Object)Logger.format(message, args), e);
        }
        catch (Throwable ex) {
            log4j.error((Object)"Oops. Error in Logger !", ex);
        }
    }

    public static void warn(String message, Object ... args) {
        try {
            org.apache.log4j.Logger.getLogger((String)Logger.getCallerClassName()).warn((Object)Logger.format(message, args));
        }
        catch (Throwable ex) {
            log4j.error((Object)"Oops. Error in Logger !", ex);
        }
    }

    public static void warn(Throwable e, String message, Object ... args) {
        try {
            org.apache.log4j.Logger.getLogger((String)Logger.getCallerClassName()).warn((Object)Logger.format(message, args), e);
        }
        catch (Throwable ex) {
            log4j.error((Object)"Oops. Error in Logger !", ex);
        }
    }

    public static void error(String message, Object ... args) {
        try {
            org.apache.log4j.Logger.getLogger((String)Logger.getCallerClassName()).error((Object)Logger.format(message, args));
        }
        catch (Throwable ex) {
            log4j.error((Object)"Oops. Error in Logger !", ex);
        }
    }

    public static void error(Throwable e, String message, Object ... args) {
        try {
            org.apache.log4j.Logger.getLogger((String)Logger.getCallerClassName()).error((Object)Logger.format(message, args), e);
        }
        catch (Throwable ex) {
            log4j.error((Object)"Oops. Error in Logger !", ex);
        }
    }

    public static void fatal(String message, Object ... args) {
        try {
            org.apache.log4j.Logger.getLogger((String)Logger.getCallerClassName()).fatal((Object)Logger.format(message, args));
        }
        catch (Throwable ex) {
            log4j.error((Object)"Oops. Error in Logger !", ex);
        }
    }

    public static void fatal(Throwable e, String message, Object ... args) {
        try {
            org.apache.log4j.Logger.getLogger((String)Logger.getCallerClassName()).fatal((Object)Logger.format(message, args), e);
        }
        catch (Throwable ex) {
            log4j.error((Object)"Oops. Error in Logger !", ex);
        }
    }

    static class CallInfo {
        public String className;
        public String methodName;

        public CallInfo() {
        }

        public CallInfo(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }
    }
}

