/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.audio;

import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import org.ncq.captcha.audio.IAudioCaptcha;
import org.ncq.captcha.enums.ILanguage;
import org.ncq.captcha.enums.LanguageEnum;
import org.ncq.captcha.exception.CaptchaException;
import org.ncq.captcha.utils.WavUtil;

public abstract class AbstractAudioCaptcha
implements IAudioCaptcha {
    protected ILanguage language;
    protected InputStream prefix;
    protected InputStream suffix;

    public AbstractAudioCaptcha(ILanguage language) {
        this.language = language == null ? LanguageEnum.ZH : language;
    }

    public AbstractAudioCaptcha(ILanguage language, InputStream prefix, InputStream suffix) {
        this.language = language == null ? LanguageEnum.ZH : language;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public byte[] getAudioBytes(String code) {
        if (code == null || code.length() <= 0) {
            throw new CaptchaException("code cannot be null");
        }
        List<InputStream> list = this.getCodeAudio(code);
        list.add(0, this.getBlank());
        if (this.prefix != null) {
            list.add(1, this.prefix);
            list.add(2, this.getBlank());
        }
        if (this.suffix != null) {
            list.add(this.getBlank());
            list.add(this.suffix);
        }
        byte[] merge = WavUtil.merge(list);
        return merge;
    }

    @Override
    public String getAudioBase64(String code) {
        byte[] bytes = this.getAudioBytes(code);
        String base64 = Base64.getEncoder().encodeToString(bytes);
        return base64;
    }

    @Override
    public String getAudioBase64Data(String code) {
        String base64 = this.getAudioBase64(code);
        StringBuilder base64Data = new StringBuilder();
        base64Data.append("data:audio/wav;base64,");
        base64Data.append(base64);
        return base64Data.toString();
    }

    protected abstract List<InputStream> getCodeAudio(String var1);

    private InputStream getBlank() {
        InputStream inputStream = AbstractAudioCaptcha.class.getResourceAsStream("/audio/blank.wav");
        return inputStream;
    }
}

