/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.concurrent.ThreadLocalRandom;
import org.ncq.captcha.utils.ImageUtil;
import org.ncq.captcha.utils.RandomUtil;

public class GraphicsUtil {
    public static Graphics2D createGraphics(BufferedImage bufferedImage, Color backgroundColor) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (null != backgroundColor) {
            graphics2D.setColor(backgroundColor);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        return graphics2D;
    }

    public static Graphics drawStr(Graphics graphics, String str, Font font, Color color, int width, int height, Color backgroundColor) {
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics.setFont(font);
        int textCenterYHeight = GraphicsUtil.getCenterYHeight(graphics, height);
        if (null != color) {
            graphics.setColor(color);
        }
        int len = str.length();
        int charWidth = width / len;
        int x = charWidth / 5;
        int y = textCenterYHeight / 5;
        ThreadLocalRandom random = RandomUtil.getRandom();
        for (int i = 0; i < len; ++i) {
            if (null == color) {
                graphics.setColor(ImageUtil.randomColor(backgroundColor));
            }
            int textHeight = textCenterYHeight - random.nextInt(-y, y);
            int textWidth = i * charWidth + random.nextInt(i == 0 ? 0 : -x, x);
            graphics.drawString(String.valueOf(str.charAt(i)), textWidth, textHeight);
        }
        return graphics;
    }

    public static int getCenterYHeight(Graphics graphics, int backgroundImageHeight) {
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = graphics.getFontMetrics();
        }
        catch (Exception e) {
            throw new RuntimeException("IndexOutOfBoundsException");
        }
        int y = null != fontMetrics ? (backgroundImageHeight - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() : backgroundImageHeight / 3;
        return y;
    }

    public static void setAlphaComposite(Graphics2D graphics2D, AlphaComposite alphaComposite) {
        if (alphaComposite != null) {
            graphics2D.setComposite(alphaComposite);
        }
    }
}

