/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.utils;

import java.util.concurrent.ThreadLocalRandom;
import org.ncq.captcha.domain.CalculationResultDTO;

public class RandomUtil {
    public static final String NUMBER = "0123456789";
    public static final String LOWER_CHAR = "abcdefghijklmnopqrstuvwxyz";
    public static final String UPPER_CHAR = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LOWER_UPPER_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMBER_LOWER_CHAR = "0123456789abcdefghijklmnopqrstuvwxyz";
    public static final String NUMBER_UPPER_CHAR = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMBER_LOWER_UPPER_CHAR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String STRING_EMPTY = "";

    public static String randomString(int length) {
        return RandomUtil.randomString(length, NUMBER_LOWER_UPPER_CHAR);
    }

    public static String randomString(int length, String randomStr) {
        if (randomStr == null || randomStr.length() <= 0 || length <= 0) {
            return STRING_EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(length);
        int randomStrLength = randomStr.length();
        for (int i = 0; i < length; ++i) {
            int randomInt = RandomUtil.randomInt(randomStrLength);
            stringBuilder.append(randomStr.charAt(randomInt));
        }
        return stringBuilder.toString();
    }

    public static int randomInt(int max) {
        return RandomUtil.getRandom().nextInt(max);
    }

    public static int randomInt(int min, int max) {
        return RandomUtil.getRandom().nextInt(min, max);
    }

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static boolean randomBoolean() {
        return RandomUtil.getRandom().nextBoolean();
    }

    public static CalculationResultDTO randomCalculation(int max) {
        return RandomUtil.randomCalculation(0, max);
    }

    public static CalculationResultDTO randomCalculation(int min, int max) {
        ThreadLocalRandom random = RandomUtil.getRandom();
        int first = random.nextInt(min, max);
        String calculationLabel = RandomUtil.randomString(1, "+-x");
        int second = random.nextInt(min, max);
        StringBuilder calculationStr = new StringBuilder();
        calculationStr.append(first);
        calculationStr.append(" ");
        calculationStr.append(calculationLabel);
        calculationStr.append(" ");
        calculationStr.append(second);
        calculationStr.append(" =");
        calculationStr.append(" ?");
        int calculationResult = 0;
        switch (calculationLabel) {
            case "+": {
                calculationResult = first + second;
                break;
            }
            case "-": {
                calculationResult = first - second;
                break;
            }
            case "x": {
                calculationResult = first * second;
                break;
            }
            default: {
                throw new RuntimeException("calculationLabel not support");
            }
        }
        CalculationResultDTO result = new CalculationResultDTO(calculationStr.toString(), first, second, calculationLabel, calculationResult);
        return result;
    }
}

