/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.ncq.captcha.exception.CaptchaException;

public final class WavUtil {
    public static byte[] merge(List<InputStream> isList) {
        if (isList == null || isList.size() <= 0) {
            throw new CaptchaException("merged file cannot be empty");
        }
        AudioInputStream audioInputStream = null;
        for (InputStream inputStream : isList) {
            if (inputStream == null) {
                throw new CaptchaException("audio file cannot be null");
            }
            AudioInputStream audio = null;
            try {
                audio = AudioSystem.getAudioInputStream(new BufferedInputStream(inputStream));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CaptchaException(e.getMessage());
            }
            if (audioInputStream == null) {
                audioInputStream = new AudioInputStream(inputStream, audio.getFormat(), audio.getFrameLength());
                continue;
            }
            audioInputStream = new AudioInputStream(new SequenceInputStream(audioInputStream, audio), audio.getFormat(), audioInputStream.getFrameLength() + audio.getFrameLength());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, baos);
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CaptchaException(e.getMessage());
        }
        return baos.toByteArray();
    }

    public static byte[] merge(InputStream ... inputStreams) {
        ArrayList<InputStream> list = new ArrayList<InputStream>(inputStreams.length);
        Collections.addAll(list, inputStreams);
        return WavUtil.merge(list);
    }

    public static byte[] merge(File ... files) {
        ArrayList<File> list = new ArrayList<File>(files.length);
        Collections.addAll(list, files);
        return WavUtil.mergeByFiles(list);
    }

    public static byte[] mergeByFiles(List<File> files) {
        if (files == null || files.size() <= 0) {
            throw new CaptchaException("merged file cannot be empty");
        }
        List<InputStream> inputStreamList = files.stream().map(m -> {
            try {
                return new FileInputStream((File)m);
            }
            catch (FileNotFoundException e) {
                throw new CaptchaException("Invalid file path");
            }
        }).collect(Collectors.toList());
        return WavUtil.merge(inputStreamList);
    }

    public static byte[] mergeByBytes(List<byte[]> byteList) {
        if (byteList == null || byteList.size() <= 0) {
            throw new CaptchaException("merged file cannot be empty");
        }
        List<InputStream> list = byteList.stream().map(m -> new ByteArrayInputStream((byte[])m)).collect(Collectors.toList());
        return WavUtil.merge(list);
    }
}

