/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.ncq.captcha.exception.CaptchaException;

public final class CaptchaFont {
    public static final String CAPTCHA_FONT_1 = "captchaFont1";
    public static final String CAPTCHA_FONT_2 = "captchaFont2";
    public static final String CAPTCHA_FONT_3 = "captchaFont3";
    public static final String CAPTCHA_FONT_4 = "captchaFont4";
    public static final String CAPTCHA_FONT_5 = "captchaFont5";
    public static final String CAPTCHA_FONT_6 = "captchaFont6";
    public static final String CAPTCHA_FONT_7 = "captchaFont7";
    public static final String CAPTCHA_FONT_8 = "captchaFont8";
    public static final String CAPTCHA_FONT_9 = "captchaFont9";
    public static final String CAPTCHA_FONT_10 = "captchaFont10";
    public static final String CAPTCHA_FONT_11 = "3Dumb";
    public static final String CAPTCHA_FONT_12 = "ApothecaryFont";
    public static final String CAPTCHA_FONT_13 = "chromohv";
    public static final String CAPTCHA_FONT_14 = "Comismsh";
    public static final String CAPTCHA_FONT_15 = "Flim-Flam";
    public static final Set<String> CAPTCHA_FONT_NAMES = new HashSet<String>(){
        {
            this.add(CaptchaFont.CAPTCHA_FONT_1);
            this.add(CaptchaFont.CAPTCHA_FONT_2);
            this.add(CaptchaFont.CAPTCHA_FONT_3);
            this.add(CaptchaFont.CAPTCHA_FONT_4);
            this.add(CaptchaFont.CAPTCHA_FONT_5);
            this.add(CaptchaFont.CAPTCHA_FONT_6);
            this.add(CaptchaFont.CAPTCHA_FONT_7);
            this.add(CaptchaFont.CAPTCHA_FONT_8);
            this.add(CaptchaFont.CAPTCHA_FONT_9);
            this.add(CaptchaFont.CAPTCHA_FONT_10);
            this.add(CaptchaFont.CAPTCHA_FONT_11);
            this.add(CaptchaFont.CAPTCHA_FONT_12);
            this.add(CaptchaFont.CAPTCHA_FONT_13);
            this.add(CaptchaFont.CAPTCHA_FONT_14);
            this.add(CaptchaFont.CAPTCHA_FONT_15);
        }
    };
    private static final Map<String, String> CAPTCHA_FONT_FILENAMES = new ConcurrentHashMap<String, String>(){
        {
            this.put(CaptchaFont.CAPTCHA_FONT_1, "font1.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_2, "font2.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_3, "font3.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_4, "font4.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_5, "font5.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_6, "font6.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_7, "font7.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_8, "font8.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_9, "font9.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_10, "font10.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_11, "3Dumb.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_12, "ApothecaryFont.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_13, "chromohv.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_14, "Comismsh.ttf");
            this.put(CaptchaFont.CAPTCHA_FONT_15, "Flim-Flam.ttf");
        }
    };

    private CaptchaFont() {
    }

    public static Font getFont(String name, int style, int size) {
        if (CAPTCHA_FONT_NAMES.contains(name)) {
            return CaptchaFont.createCustomFont(name, style, size);
        }
        return new Font(name, style, size);
    }

    public static Font getFont(InputStream inputStream, int style, int size) {
        try {
            return Font.createFont(0, inputStream).deriveFont(style, size);
        }
        catch (FontFormatException e) {
            throw new CaptchaException(e.getMessage());
        }
        catch (IOException ioException) {
            throw new CaptchaException(ioException.getMessage());
        }
    }

    private static Font createCustomFont(String name, int style, int size) {
        String fontFileName = CAPTCHA_FONT_FILENAMES.get(name);
        if (fontFileName == null) {
            throw new CaptchaException("not find font file name");
        }
        InputStream resourceAsStream = CaptchaFont.class.getResourceAsStream("/font/".concat(fontFileName));
        return CaptchaFont.getFont(resourceAsStream, style, size);
    }
}

