/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import org.ncq.captcha.enums.Interference;
import org.ncq.captcha.image.AbstractDrawing;
import org.ncq.captcha.image.DrawInterferenceUtil;

public class BezierOvalCaptcha
extends AbstractDrawing {
    public BezierOvalCaptcha(int width, int height, int interferenceCount, Font font, Color fontColor, Color backgroundColor, Color interferenceColor, AlphaComposite alphaComposite) {
        super(width, height, interferenceCount, font, fontColor, backgroundColor, interferenceColor, alphaComposite);
    }

    public BezierOvalCaptcha(int width, int height, int interferenceCount) {
        super(width, height, interferenceCount, null, null, null, null, null);
    }

    @Override
    protected void drawInterference(Graphics2D graphics2D) {
        DrawInterferenceUtil.drawBezierCurve(graphics2D, this.width, this.height, this.getInterferenceColorOrRandom());
        for (int i = 0; i < 2; ++i) {
            DrawInterferenceUtil.drawOval(graphics2D, this.width, this.height, this.getInterferenceColorOrRandom());
        }
    }

    @Override
    public boolean isSupport(Interference interference) {
        return false;
    }
}

