/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.utils;

import java.io.InputStream;
import org.ncq.captcha.audio.DefaultAudioCaptcha;
import org.ncq.captcha.audio.IAudioCaptcha;
import org.ncq.captcha.enums.ILanguage;
import org.ncq.captcha.enums.LanguageEnum;

public class AudioCaptchaUtil {
    public static String getAudioBase64Data(String code) {
        return AudioCaptchaUtil.getAudioBase64Data(code, LanguageEnum.ZH);
    }

    public static String getAudioBase64Data(String code, ILanguage language) {
        return AudioCaptchaUtil.getAudioBase64Data(code, language, AudioCaptchaUtil.getDefaultPrefixAudio(language), AudioCaptchaUtil.getDefaultSuffixAudio(language));
    }

    public static String getAudioBase64Data(String code, ILanguage language, InputStream prefix, InputStream suffix) {
        DefaultAudioCaptcha audioCaptcha = new DefaultAudioCaptcha(language, prefix, suffix);
        return audioCaptcha.getAudioBase64Data(code);
    }

    public static String getAudioBase64(String code) {
        return AudioCaptchaUtil.getAudioBase64(code, LanguageEnum.ZH);
    }

    public static String getAudioBase64(String code, ILanguage language) {
        return AudioCaptchaUtil.getAudioBase64(code, language, AudioCaptchaUtil.getDefaultPrefixAudio(language), AudioCaptchaUtil.getDefaultSuffixAudio(language));
    }

    public static String getAudioBase64(String code, ILanguage language, InputStream prefix, InputStream suffix) {
        DefaultAudioCaptcha audioCaptcha = new DefaultAudioCaptcha(language, prefix, suffix);
        return audioCaptcha.getAudioBase64(code);
    }

    public static byte[] getAudioBytes(String code) {
        return AudioCaptchaUtil.getAudioBytes(code, LanguageEnum.ZH);
    }

    public static byte[] getAudioBytes(String code, ILanguage language) {
        return AudioCaptchaUtil.getAudioBytes(code, language, AudioCaptchaUtil.getDefaultPrefixAudio(language), AudioCaptchaUtil.getDefaultSuffixAudio(language));
    }

    public static byte[] getAudioBytes(String code, ILanguage language, InputStream prefix, InputStream suffix) {
        DefaultAudioCaptcha audioCaptcha = new DefaultAudioCaptcha(language, prefix, suffix);
        return audioCaptcha.getAudioBytes(code);
    }

    public static String getAudioBase64Data(String code, IAudioCaptcha audioCaptcha) {
        String audioBase64Data = audioCaptcha.getAudioBase64Data(code);
        return audioBase64Data;
    }

    public static String getAudioBase64(String code, IAudioCaptcha audioCaptcha) {
        String audioBase64 = audioCaptcha.getAudioBase64(code);
        return audioBase64;
    }

    public static byte[] getAudioBytes(String code, IAudioCaptcha audioCaptcha) {
        byte[] bytes = audioCaptcha.getAudioBytes(code);
        return bytes;
    }

    private static InputStream getDefaultPrefixAudio(ILanguage language) {
        language = language == null ? LanguageEnum.ZH : language;
        String path = "/audio/" + language.getName() + "/prefix.wav";
        return AudioCaptchaUtil.class.getResourceAsStream(path.toLowerCase());
    }

    private static InputStream getDefaultSuffixAudio(ILanguage language) {
        language = language == null ? LanguageEnum.ZH : language;
        String path = "/audio/" + language.getName() + "/suffix.wav";
        return AudioCaptchaUtil.class.getResourceAsStream(path.toLowerCase());
    }
}

