/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.utils;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;
import org.ncq.captcha.utils.RandomUtil;

public class ImageUtil {
    private static final int RGB_COLOR_UPPER_LIMIT = 256;
    public static final String PNG = "PNG";
    public static final String GIF = "GIF";

    public static void write(Image image, String imageType, ByteArrayOutputStream out) {
        try {
            ImageIO.write((RenderedImage)((Object)image), imageType, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writePng(Image image, ByteArrayOutputStream out) {
        ImageUtil.write(image, PNG, out);
    }

    public static Color randomColor() {
        ThreadLocalRandom random = RandomUtil.getRandom();
        return new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
    }

    public static Color randomColor(Color color) {
        Color c = ImageUtil.randomColor();
        if (color == null) {
            return c;
        }
        if (c.equals(color)) {
            return ImageUtil.randomColor(color);
        }
        return c;
    }
}

