/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.audio;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import org.ncq.captcha.audio.IAudioCaptcha;
import org.ncq.captcha.enums.ILanguage;
import org.ncq.captcha.enums.LanguageEnum;
import org.ncq.captcha.exception.CaptchaException;
import org.ncq.captcha.utils.AudioCaptchaUtil;
import org.ncq.captcha.utils.IOUtil;
import org.ncq.captcha.utils.WavUtil;

public abstract class AbstractAudioCaptcha
implements IAudioCaptcha {
    protected ILanguage language;
    protected byte[] prefix;
    protected byte[] suffix;

    public AbstractAudioCaptcha(ILanguage language) {
        this.language = language == null ? LanguageEnum.ZH : language;
        String prefixPath = "/audio/" + language.getName() + "/prefix.wav";
        InputStream prefixStream = AudioCaptchaUtil.class.getResourceAsStream(prefixPath.toLowerCase());
        this.prefix = IOUtil.toByteArray(prefixStream);
        String suffixPath = "/audio/" + language.getName() + "/suffix.wav";
        InputStream suffixStream = AudioCaptchaUtil.class.getResourceAsStream(suffixPath.toLowerCase());
        this.suffix = IOUtil.toByteArray(suffixStream);
        IOUtil.close(prefixStream);
        IOUtil.close(suffixStream);
    }

    public AbstractAudioCaptcha(ILanguage language, byte[] prefix, byte[] suffix) {
        this.language = language == null ? LanguageEnum.ZH : language;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public byte[] getAudioBytes(String code) {
        ByteArrayInputStream inputStream;
        if (code == null || code.length() <= 0) {
            throw new CaptchaException("code cannot be null");
        }
        List<InputStream> list = this.getCodeAudio(code);
        list.add(0, this.getBlank());
        if (this.prefix != null) {
            inputStream = new ByteArrayInputStream(this.prefix);
            list.add(1, inputStream);
            list.add(2, this.getBlank());
        }
        if (this.suffix != null) {
            inputStream = new ByteArrayInputStream(this.suffix);
            list.add(this.getBlank());
            list.add(inputStream);
        }
        byte[] merge = WavUtil.merge(list);
        return merge;
    }

    @Override
    public String getAudioBase64(String code) {
        byte[] bytes = this.getAudioBytes(code);
        String base64 = Base64.getEncoder().encodeToString(bytes);
        return base64;
    }

    @Override
    public String getAudioBase64Data(String code) {
        String base64 = this.getAudioBase64(code);
        StringBuilder base64Data = new StringBuilder();
        base64Data.append("data:audio/wav;base64,");
        base64Data.append(base64);
        return base64Data.toString();
    }

    protected abstract List<InputStream> getCodeAudio(String var1);

    private InputStream getBlank() {
        InputStream inputStream = AbstractAudioCaptcha.class.getResourceAsStream("/audio/blank.wav");
        return inputStream;
    }
}

