/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.audio;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.ncq.captcha.audio.AbstractAudioCaptcha;
import org.ncq.captcha.enums.ILanguage;
import org.ncq.captcha.exception.CaptchaException;

public class DefaultAudioCaptcha
extends AbstractAudioCaptcha {
    public DefaultAudioCaptcha(ILanguage language) {
        super(language);
    }

    public DefaultAudioCaptcha(ILanguage language, byte[] prefix, byte[] suffix) {
        super(language, prefix, suffix);
    }

    @Override
    protected List<InputStream> getCodeAudio(String code) {
        ArrayList<InputStream> list = new ArrayList<InputStream>();
        for (int i = 0; i < code.length(); ++i) {
            boolean flag = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".contains(String.valueOf(code.charAt(i)));
            if (!flag) {
                throw new CaptchaException("default audio captcha supports 0 ~ 9 or a ~ z or A ~ Z");
            }
            String path = "/audio/" + this.language.getName() + "/" + code.charAt(i) + ".wav";
            InputStream inputStream = DefaultAudioCaptcha.class.getResourceAsStream(path.toLowerCase());
            list.add(inputStream);
        }
        return list;
    }
}

