/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.click;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import org.ncq.captcha.click.IClickCaptcha;
import org.ncq.captcha.domain.ClickCaptchaResult;
import org.ncq.captcha.utils.IOUtil;
import org.ncq.captcha.utils.ImageUtil;

public abstract class AbstractClickCaptcha<T extends ClickCaptchaResult>
implements IClickCaptcha<T> {
    protected Font font;
    protected Color fontColor;

    public AbstractClickCaptcha(Font font, Color fontColor) {
        this.font = font == null ? new Font("Arial", 1, 35) : font;
        this.fontColor = fontColor == null ? Color.BLACK : fontColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClickCaptchaResult result(BufferedImage bufferedImage, String imageType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bytes = null;
        try {
            ImageUtil.write((Image)bufferedImage, imageType, out);
            bytes = out.toByteArray();
        }
        finally {
            IOUtil.close(out);
        }
        ClickCaptchaResult result = new ClickCaptchaResult();
        result.setBytes(bytes);
        String base64 = Base64.getEncoder().encodeToString(bytes);
        result.setBase64(base64);
        StringBuilder imageBase64Data = new StringBuilder();
        imageBase64Data.append("data:image/");
        imageBase64Data.append(imageType);
        imageBase64Data.append(";base64,");
        imageBase64Data.append(base64);
        result.setBase64Data(imageBase64Data.toString());
        return result;
    }
}

