/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.click;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.ncq.captcha.click.AbstractClickCaptcha;
import org.ncq.captcha.click.ClickBlock;
import org.ncq.captcha.domain.CharClickCaptchaResult;
import org.ncq.captcha.domain.ClickCaptchaResult;
import org.ncq.captcha.domain.Point;
import org.ncq.captcha.utils.ClickCaptchaUtil;
import org.ncq.captcha.utils.GraphicsUtil;
import org.ncq.captcha.utils.ImageUtil;
import org.ncq.captcha.utils.RandomUtil;

public class CharClickCaptcha
extends AbstractClickCaptcha<CharClickCaptchaResult> {
    public CharClickCaptcha(Font font, Color fontColor) {
        super(font, fontColor);
    }

    @Override
    public CharClickCaptchaResult getClickImage(String code, byte[] background) {
        BufferedImage bufferedImage = background == null ? ImageUtil.read(ClickCaptchaUtil.class.getResourceAsStream("/image/bg.jpg")) : ImageUtil.read(background);
        String str = RandomUtil.randomRearrange(code.length(), code);
        Graphics2D graphics = GraphicsUtil.createGraphics(bufferedImage, null);
        ArrayList<CharClickCaptchaResult.CharPosition> list = new ArrayList<CharClickCaptchaResult.CharPosition>();
        BigDecimal two = new BigDecimal(2);
        graphics.setFont(this.font);
        graphics.setColor(this.fontColor);
        int fontHeight = GraphicsUtil.getFontHeight(graphics, this.font);
        int fontSize = this.font.getSize();
        BigDecimal halfFontSize = new BigDecimal(fontSize).divide(two, 4, 0);
        ArrayList<ClickBlock> blockList = new ArrayList<ClickBlock>();
        if ((bufferedImage.getHeight() - 10) / fontHeight > 2) {
            int rowH = bufferedImage.getHeight() / 2;
            int c = 0;
            c = str.length() % 2 > 0 ? str.length() / 2 + 1 : str.length() / 2;
            int column = bufferedImage.getWidth() / c;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < c; ++j) {
                    ClickBlock block = new ClickBlock();
                    block.setHeight(rowH);
                    block.setWidth(column);
                    block.setX(j * column);
                    if (i == 0) {
                        block.setY(rowH);
                    } else {
                        block.setY(rowH * 2);
                    }
                    blockList.add(block);
                }
            }
        } else {
            int column = bufferedImage.getWidth() / str.length();
            for (int i = 0; i < str.length(); ++i) {
                ClickBlock block = new ClickBlock();
                block.setHeight(bufferedImage.getHeight());
                block.setWidth(column);
                block.setX(i * column);
                block.setY(block.getHeight());
                blockList.add(block);
            }
        }
        for (int i = 0; i < str.length(); ++i) {
            String s = String.valueOf(str.charAt(i));
            int r = RandomUtil.randomInt(0, blockList.size());
            ClickBlock block = (ClickBlock)blockList.get(r);
            Point point = GraphicsUtil.randomStrPosition(graphics, s, this.font, block.getWidth(), block.getHeight());
            double radius = halfFontSize.doubleValue();
            int x = block.getX() + point.getX();
            int y = block.getY() - (block.getHeight() - point.getY());
            CharClickCaptchaResult.CharPosition charPosition = new CharClickCaptchaResult.CharPosition();
            graphics.drawString(s, x, y);
            charPosition.setRadius(radius);
            charPosition.setCharStr(s);
            charPosition.setX(x + halfFontSize.intValue());
            charPosition.setY(y - halfFontSize.setScale(0, 0).intValue());
            list.add(charPosition);
            blockList.remove(r);
        }
        ClickCaptchaResult imageInfo = this.result(bufferedImage, "PNG");
        CharClickCaptchaResult result = new CharClickCaptchaResult(imageInfo.getBase64(), imageInfo.getBase64Data(), imageInfo.getBytes());
        result.setCharPositionList(list);
        return result;
    }
}

