/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.concurrent.ThreadLocalRandom;
import org.ncq.captcha.image.IImageCaptcha;
import org.ncq.captcha.image.gif.AnimatedGifEncoder;
import org.ncq.captcha.utils.GraphicsUtil;
import org.ncq.captcha.utils.IOUtil;
import org.ncq.captcha.utils.ImageUtil;
import org.ncq.captcha.utils.RandomUtil;

public abstract class AbstractDrawing
implements IImageCaptcha {
    protected int width;
    protected int height;
    protected int interferenceCount;
    protected Font font;
    protected Color fontColor;
    protected Color backgroundColor;
    protected Color interferenceColor;
    protected AlphaComposite alphaComposite;
    protected int gifDelay = 150;

    public AbstractDrawing(int width, int height, int interferenceCount, Font font, Color fontColor, Color backgroundColor, Color interferenceColor, AlphaComposite alphaComposite) {
        this.width = width < 10 ? 10 : width;
        this.height = height < 10 ? 10 : height;
        this.interferenceCount = interferenceCount;
        this.font = font == null ? new Font("Arial", 1, (int)((double)this.height * 0.65)) : font;
        this.fontColor = fontColor;
        this.backgroundColor = backgroundColor == null ? Color.WHITE : backgroundColor;
        this.interferenceColor = interferenceColor;
        this.alphaComposite = alphaComposite;
    }

    protected abstract void drawInterference(Graphics2D var1);

    protected Image createImage(String code) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(image, this.backgroundColor);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GraphicsUtil.setAlphaComposite(graphics2D, this.alphaComposite);
        GraphicsUtil.drawStr(graphics2D, code, this.font, this.fontColor, this.width, this.height, this.backgroundColor);
        if (this.interferenceCount > 0) {
            for (int i = 0; i < this.interferenceCount; ++i) {
                this.drawInterference(graphics2D);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] createGifImage(String code) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AnimatedGifEncoder gif = new AnimatedGifEncoder();
        gif.start(out);
        gif.setQuality(10);
        gif.setDelay(this.gifDelay);
        gif.setRepeat(0);
        char[] chars = code.toCharArray();
        Color[] fontColor = new Color[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            fontColor[i] = this.fontColor == null ? ImageUtil.randomColor(this.backgroundColor) : this.fontColor;
            BufferedImage frame = this.graphicsImage(chars, fontColor, chars, i);
            gif.addFrame(frame);
            frame.flush();
        }
        gif.finish();
        try {
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            IOUtil.close(out);
        }
    }

    @Override
    public String getImageBase64(String code) {
        byte[] imageBytes = this.getImageBytes(code);
        return Base64.getEncoder().encodeToString(imageBytes);
    }

    @Override
    public String getImageBase64Data(String code) {
        String imageBase64 = this.getImageBase64(code);
        StringBuilder imageBase64Data = new StringBuilder();
        imageBase64Data.append("data:image/");
        imageBase64Data.append("PNG");
        imageBase64Data.append(";base64,");
        imageBase64Data.append(imageBase64);
        return imageBase64Data.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getImageBytes(String code) {
        Image image = this.createImage(code);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageUtil.write(image, "PNG", out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            IOUtil.close(out);
        }
    }

    @Override
    public String getGifImageBase64(String code) {
        byte[] imageBytes = this.getGifImageBytes(code);
        return Base64.getEncoder().encodeToString(imageBytes);
    }

    @Override
    public String getGifImageBase64Data(String code) {
        String imageBase64 = this.getGifImageBase64(code);
        StringBuilder imageBase64Data = new StringBuilder();
        imageBase64Data.append("data:image/");
        imageBase64Data.append("GIF");
        imageBase64Data.append(";base64,");
        imageBase64Data.append(imageBase64);
        return imageBase64Data.toString();
    }

    @Override
    public byte[] getGifImageBytes(String code) {
        return this.createGifImage(code);
    }

    protected Color getInterferenceColorOrRandom() {
        if (this.interferenceColor != null) {
            return this.interferenceColor;
        }
        return ImageUtil.randomColor(this.backgroundColor);
    }

    private BufferedImage graphicsImage(char[] chars, Color[] fontColor, char[] words, int flag) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.backgroundColor == null ? Color.BLACK : this.backgroundColor);
        graphics2D.fillRect(0, 0, this.width, this.height);
        float y = (this.height >> 1) + (this.font.getSize() >> 1);
        float m = 1.0f * (float)(this.width - chars.length * this.font.getSize()) / (float)chars.length;
        float x = Math.max(m / 2.0f, 2.0f);
        graphics2D.setFont(this.font);
        if (null != this.alphaComposite) {
            graphics2D.setComposite(this.alphaComposite);
        }
        if (this.interferenceCount > 0) {
            for (int j = 0; j < this.interferenceCount; ++j) {
                this.drawInterference(graphics2D);
            }
        }
        for (int i = 0; i < chars.length; ++i) {
            AlphaComposite ac = AlphaComposite.getInstance(3, this.getAlpha(chars.length, flag, i));
            graphics2D.setComposite(ac);
            graphics2D.setColor(fontColor[i]);
            graphics2D.drawString(words[i] + "", x + ((float)this.font.getSize() + m) * (float)i, y);
        }
        graphics2D.dispose();
        return image;
    }

    private float getAlpha(int v, int i, int j) {
        int num = i + j;
        float r = 1.0f / (float)v;
        float s = (float)(v + 1) * r;
        return num > v ? (float)num * r - s : (float)num * r;
    }

    public void setGifDelay(int gifDelay) {
        this.gifDelay = gifDelay;
    }

    private void shearX(Graphics graphics) {
        ThreadLocalRandom random = RandomUtil.getRandom();
        int period = random.nextInt(this.width);
        boolean frames = true;
        int phase = random.nextInt(2);
        for (int i = 0; i < this.width; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            graphics.copyArea(0, i, this.width, 1, (int)d, 0);
            graphics.setColor(this.backgroundColor);
            graphics.drawLine((int)d, i, 0, i);
            graphics.drawLine((int)d + this.width, i, this.width, i);
        }
    }

    private void shearY(Graphics graphics) {
        int period = RandomUtil.randomInt(this.height >> 1);
        int frames = 20;
        int phase = 7;
        for (int i = 0; i < this.width; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            graphics.copyArea(i, 0, 1, this.height, 0, (int)d);
            graphics.setColor(this.backgroundColor);
            graphics.drawLine(i, (int)d, i, 0);
            graphics.drawLine(i, (int)d + this.height, i, this.height);
        }
    }
}

