/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.utils;

import java.io.InputStream;
import org.ncq.captcha.audio.DefaultAudioCaptcha;
import org.ncq.captcha.audio.IAudioCaptcha;
import org.ncq.captcha.enums.ILanguage;
import org.ncq.captcha.enums.LanguageEnum;
import org.ncq.captcha.utils.IOUtil;

public class AudioCaptchaUtil {
    public static String getAudioBase64Data(String code) {
        return AudioCaptchaUtil.getAudioBase64Data(code, LanguageEnum.ZH);
    }

    public static String getAudioBase64Data(String code, ILanguage language) {
        return AudioCaptchaUtil.getAudioBase64Data(code, language, AudioCaptchaUtil.getDefaultPrefixAudio(language), AudioCaptchaUtil.getDefaultSuffixAudio(language));
    }

    public static String getAudioBase64Data(String code, ILanguage language, byte[] prefix, byte[] suffix) {
        DefaultAudioCaptcha audioCaptcha = new DefaultAudioCaptcha(language, prefix, suffix);
        return audioCaptcha.getAudioBase64Data(code);
    }

    public static String getAudioBase64(String code) {
        return AudioCaptchaUtil.getAudioBase64(code, LanguageEnum.ZH);
    }

    public static String getAudioBase64(String code, ILanguage language) {
        return AudioCaptchaUtil.getAudioBase64(code, language, AudioCaptchaUtil.getDefaultPrefixAudio(language), AudioCaptchaUtil.getDefaultSuffixAudio(language));
    }

    public static String getAudioBase64(String code, ILanguage language, byte[] prefix, byte[] suffix) {
        DefaultAudioCaptcha audioCaptcha = new DefaultAudioCaptcha(language, prefix, suffix);
        return audioCaptcha.getAudioBase64(code);
    }

    public static byte[] getAudioBytes(String code) {
        return AudioCaptchaUtil.getAudioBytes(code, LanguageEnum.ZH);
    }

    public static byte[] getAudioBytes(String code, ILanguage language) {
        return AudioCaptchaUtil.getAudioBytes(code, language, AudioCaptchaUtil.getDefaultPrefixAudio(language), AudioCaptchaUtil.getDefaultSuffixAudio(language));
    }

    public static byte[] getAudioBytes(String code, ILanguage language, byte[] prefix, byte[] suffix) {
        DefaultAudioCaptcha audioCaptcha = new DefaultAudioCaptcha(language, prefix, suffix);
        return audioCaptcha.getAudioBytes(code);
    }

    public static String getAudioBase64Data(String code, IAudioCaptcha audioCaptcha) {
        String audioBase64Data = audioCaptcha.getAudioBase64Data(code);
        return audioBase64Data;
    }

    public static String getAudioBase64(String code, IAudioCaptcha audioCaptcha) {
        String audioBase64 = audioCaptcha.getAudioBase64(code);
        return audioBase64;
    }

    public static byte[] getAudioBytes(String code, IAudioCaptcha audioCaptcha) {
        byte[] bytes = audioCaptcha.getAudioBytes(code);
        return bytes;
    }

    private static byte[] getDefaultPrefixAudio(ILanguage language) {
        language = language == null ? LanguageEnum.ZH : language;
        String path = "/audio/" + language.getName() + "/prefix.wav";
        InputStream resourceAsStream = AudioCaptchaUtil.class.getResourceAsStream(path.toLowerCase());
        byte[] bytes = IOUtil.toByteArray(resourceAsStream);
        IOUtil.close(resourceAsStream);
        return bytes;
    }

    private static byte[] getDefaultSuffixAudio(ILanguage language) {
        language = language == null ? LanguageEnum.ZH : language;
        String path = "/audio/" + language.getName() + "/suffix.wav";
        InputStream resourceAsStream = AudioCaptchaUtil.class.getResourceAsStream(path.toLowerCase());
        byte[] bytes = IOUtil.toByteArray(resourceAsStream);
        IOUtil.close(resourceAsStream);
        return bytes;
    }
}

