/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.concurrent.ThreadLocalRandom;
import org.ncq.captcha.domain.Point;
import org.ncq.captcha.utils.ImageUtil;
import org.ncq.captcha.utils.RandomUtil;

public class GraphicsUtil {
    public static Graphics2D createGraphics(BufferedImage bufferedImage, Color backgroundColor) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (null != backgroundColor) {
            graphics2D.setColor(backgroundColor);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        return graphics2D;
    }

    public static Graphics drawStr(Graphics graphics, String str, Font font, Color color, int width, int height, Color backgroundColor) {
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics.setFont(font);
        int textCenterYHeight = GraphicsUtil.getCenterYHeight(graphics, height);
        if (null != color) {
            graphics.setColor(color);
        }
        int len = str.length();
        int charWidth = width / len;
        for (int i = 0; i < len; ++i) {
            if (null == color) {
                graphics.setColor(ImageUtil.randomColor(backgroundColor));
            }
            String s = String.valueOf(str.charAt(i));
            Point point = GraphicsUtil.randomStrPosition(graphics, s, font, charWidth, height);
            graphics.drawString(s, point.getX() + charWidth * i, point.getY());
        }
        return graphics;
    }

    public static Point randomStrPosition(Graphics graphics, String str, Font font, int width, int height) {
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int charWidth = GraphicsUtil.getCharWidth(graphics, str, font);
        int charHeight = GraphicsUtil.getFontHeight(graphics, font);
        ThreadLocalRandom random = RandomUtil.getRandom();
        int x = 0;
        if (width <= charWidth) {
            x = 0;
        } else {
            x = random.nextInt(0, width);
            if (x + charWidth > width) {
                x = width - charWidth;
            }
        }
        int y = 0;
        if (height <= charHeight) {
            y = (height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
        } else {
            y = random.nextInt(0, height);
            if (y < charHeight) {
                y = charHeight;
            }
        }
        return new Point(x, y);
    }

    public static int getCenterYHeight(Graphics graphics, int backgroundImageHeight) {
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = graphics.getFontMetrics();
        }
        catch (Exception e) {
            throw new RuntimeException("IndexOutOfBoundsException");
        }
        int y = null != fontMetrics ? (backgroundImageHeight - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() : backgroundImageHeight / 3;
        return y;
    }

    public static void setAlphaComposite(Graphics2D graphics2D, AlphaComposite alphaComposite) {
        if (alphaComposite != null) {
            graphics2D.setComposite(alphaComposite);
        }
    }

    public static int getFontHeight(Graphics graphics, Font font) {
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        return fontMetrics.getHeight();
    }

    public static int getCharWidth(Graphics graphics, String str, Font font) {
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        return fontMetrics.stringWidth(str);
    }

    public static AffineTransform getRotation(int degree, int x, int y) {
        AffineTransform at = new AffineTransform();
        at.setToRotation(Math.toRadians(degree), x, y);
        return at;
    }
}

