/*
 * Decompiled with CFR 0.152.
 */
package org.ncq.captcha.utils;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;
import org.ncq.captcha.exception.CaptchaException;
import org.ncq.captcha.utils.IOUtil;
import org.ncq.captcha.utils.RandomUtil;

public class ImageUtil {
    private static final int RGB_COLOR_UPPER_LIMIT = 256;
    public static final String PNG = "PNG";
    public static final String GIF = "GIF";

    public static void write(Image image, String imageType, ByteArrayOutputStream out) {
        try {
            ImageIO.write((RenderedImage)((Object)image), imageType, out);
        }
        catch (Exception e) {
            throw new CaptchaException("image to ByteArrayOutputStream error", e);
        }
    }

    public static void write(Image image, String imageType, OutputStream outputStream) {
        try {
            ImageIO.write((RenderedImage)((Object)image), imageType, outputStream);
        }
        catch (IOException e) {
            throw new CaptchaException("image to outputStream error", e);
        }
    }

    public static void write(Image image, String imageType, File file) {
        try {
            ImageIO.write((RenderedImage)((Object)image), imageType, file);
        }
        catch (IOException e) {
            throw new CaptchaException("image to file error", e);
        }
    }

    public static BufferedImage read(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (IOException e) {
            throw new CaptchaException("file to image error", e);
        }
    }

    public static BufferedImage read(URL url) {
        try {
            return ImageIO.read(url);
        }
        catch (IOException e) {
            throw new CaptchaException("url to image error", e);
        }
    }

    public static BufferedImage read(InputStream inputStream) {
        try {
            return ImageIO.read(inputStream);
        }
        catch (IOException e) {
            throw new CaptchaException("inputStream to image error", e);
        }
    }

    public static BufferedImage read(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            BufferedImage bufferedImage = ImageUtil.read(inputStream);
            return bufferedImage;
        }
        finally {
            IOUtil.close(inputStream);
        }
    }

    public static void writePng(Image image, ByteArrayOutputStream out) {
        ImageUtil.write(image, PNG, out);
    }

    public static Color randomColor() {
        ThreadLocalRandom random = RandomUtil.getRandom();
        return new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
    }

    public static Color randomColor(Color color) {
        Color c = ImageUtil.randomColor();
        if (color == null) {
            return c;
        }
        if (c.equals(color)) {
            return ImageUtil.randomColor(color);
        }
        return c;
    }

    public static BufferedImage cut(BufferedImage image, int x, int y, int width, int height) {
        return image.getSubimage(x, y, width, height);
    }
}

