/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.java;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.nkjmlab.util.java.function.Try;

public class Base64Utils {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String decode(String base64EncodedData) {
        byte[] decoded = Base64.getDecoder().decode(base64EncodedData.replaceFirst("data:.*?base64,", ""));
        try (InputStreamReader in = new InputStreamReader((InputStream)new ByteArrayInputStream(decoded), StandardCharsets.UTF_8);){
            String string;
            try (BufferedReader br = new BufferedReader(in);){
                String line;
                Object result = "";
                while ((line = br.readLine()) != null) {
                    result = (String)result + line + System.lineSeparator();
                }
                string = result;
            }
            return string;
        }
        catch (IOException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public static BufferedImage decodeToImage(String encodedImage, String formatName) {
        BufferedImage bufferedImage;
        byte[] decoded = Base64.getDecoder().decode(encodedImage.replaceFirst("data:.*?base64,", ""));
        ByteArrayInputStream in = new ByteArrayInputStream(decoded);
        try {
            BufferedImage image;
            bufferedImage = image = ImageIO.read(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw Try.rethrow((Throwable)e);
            }
        }
        ((InputStream)in).close();
        return bufferedImage;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String encode(RenderedImage image, String formatName) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (BufferedOutputStream bos = new BufferedOutputStream(baos);){
                ImageIO.write(image, formatName, bos);
                bos.flush();
                string = Base64.getEncoder().encodeToString(baos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw Try.rethrow((Throwable)e);
        }
    }
}

