/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.javax.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nkjmlab.util.java.json.JsonMapper;
import org.nkjmlab.util.java.json.jsonrpc.JsonRpcRequest;
import org.nkjmlab.util.java.json.jsonrpc.JsonRpcResponse;
import org.nkjmlab.util.java.json.jsonrpc.JsonRpcUtils;
import org.nkjmlab.util.java.logging.LogManager;
import org.nkjmlab.util.java.logging.Logger;

public class JsonRpcService {
    private static final Logger log = LogManager.getLogger();
    private JsonMapper mapper;

    public JsonRpcService(JsonMapper mapper) {
        this.mapper = mapper;
    }

    public JsonRpcResponse callJsonRpc(Object service, JsonRpcRequest jreq) {
        return JsonRpcUtils.callJsonRpc((JsonMapper)this.mapper, (Object)service, (JsonRpcRequest)jreq);
    }

    public JsonRpcResponse callHttpJsonRpc(Object service, HttpServletRequest req, HttpServletResponse res) {
        JsonRpcRequest jreq = JsonRpcService.toJsonRpcRequest(this.mapper, req);
        return this.callHttpJsonRpc(service, jreq, res);
    }

    public JsonRpcResponse callHttpJsonRpc(Object service, JsonRpcRequest jreq, HttpServletResponse res) {
        JsonRpcService.setContentTypeToJson(res);
        JsonRpcService.setAccessControlAllowOriginToWildCard(res);
        JsonRpcService.setAccessControlAllowMethodsToWildCard(res);
        JsonRpcService.setAccessControlAllowHeadersToWildCard(res);
        JsonRpcResponse result = JsonRpcUtils.callJsonRpc((JsonMapper)this.mapper, (Object)service, (JsonRpcRequest)jreq);
        if (result.hasError()) {
            res.setStatus(500);
        } else {
            res.setStatus(200);
        }
        return result;
    }

    public static JsonRpcRequest toJsonRpcRequest(JsonMapper mapper, HttpServletRequest req) {
        try {
            return JsonRpcUtils.toJsonRpcRequest((JsonMapper)mapper, (InputStream)JsonRpcService.getInputStream(req));
        }
        catch (Throwable e) {
            log.error(e, e);
            throw new RuntimeException(e);
        }
    }

    private static InputStream getInputStream(HttpServletRequest req) throws IOException {
        ServletInputStream is = req.getInputStream();
        String contentEncoding = req.getHeader("Content-Encoding");
        if (contentEncoding == null) {
            return is;
        }
        if (contentEncoding.equals("deflate")) {
            return new InflaterInputStream((InputStream)is);
        }
        if (contentEncoding.equals("gzip")) {
            return new GZIPInputStream((InputStream)is);
        }
        return is;
    }

    public static void setContentTypeToJson(HttpServletResponse res) {
        res.setContentType("application/json;charset=UTF-8");
    }

    public static void setAccessControlAllowOriginToWildCard(HttpServletResponse res) {
        res.setHeader("Access-Control-Allow-Origin", "*");
    }

    public static void setAccessControlAllowMethodsToWildCard(HttpServletResponse res) {
        res.setHeader("Access-Control-Allow-Methods", "*");
    }

    public static void setAccessControlAllowHeadersToWildCard(HttpServletResponse res) {
        res.setHeader("Access-Control-Allow-Headers", "*");
    }
}

