/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.javax.servlet;

import java.util.Optional;
import javax.servlet.http.HttpSession;

public class UserSession {
    private static final String USER_ID = "userId";
    private final HttpSession session;

    public static UserSession wrap(HttpSession session) {
        return new UserSession(session);
    }

    protected UserSession(HttpSession session) {
        this.session = session;
    }

    public Object getAttribute(String key) {
        return this.session.getAttribute(key);
    }

    public String getId() {
        return this.session.getId();
    }

    public HttpSession getSession() {
        return this.session;
    }

    public Optional<String> getUserId() {
        return Optional.ofNullable(this.getAttribute(USER_ID)).map(o -> o.toString());
    }

    public void invalidate() {
        this.session.invalidate();
    }

    public boolean isLogined() {
        return this.getAttribute(USER_ID) != null;
    }

    public void setAttribute(String key, Object value) {
        this.session.setAttribute(key, value);
    }

    public void setMaxInactiveInterval(int maxInterval) {
        this.session.setMaxInactiveInterval(maxInterval);
    }

    public void setUserId(String userId) {
        this.session.setAttribute(USER_ID, (Object)userId);
    }
}

