/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.jsonic;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;
import org.nkjmlab.util.java.io.FileUtils;
import org.nkjmlab.util.java.json.JsonMapper;

public class JsonicMapper
implements JsonMapper {
    private static final JsonicMapper DEFAULT_MAPPER = new JsonicMapper();

    public static JsonicMapper getDefaultMapper() {
        return DEFAULT_MAPPER;
    }

    public <T> T toObject(String json, Class<T> clazz) {
        return JsonicMapper.decode(json, clazz);
    }

    public <T> T toObject(File in, Class<T> clazz) {
        return JsonicMapper.decode(in, clazz);
    }

    public <T> T toObject(Reader in, Class<T> clazz) {
        return JsonicMapper.decode(in, clazz);
    }

    public <T> T toObject(InputStream in, Class<T> clazz) {
        return JsonicMapper.decode(in, clazz);
    }

    public String toJson(Object obj) {
        return this.toJson(obj, false);
    }

    public void toJsonAndWrite(Object obj, File out, boolean prettyPrint) {
        JsonicMapper.encode(obj, out, prettyPrint);
    }

    public void toJsonAndWrite(Object obj, Writer out, boolean prettyPrint) {
        JsonicMapper.encode(obj, out, prettyPrint);
    }

    public void toJsonAndWrite(Object obj, OutputStream out, boolean prettyPrint) {
        JsonicMapper.encode(obj, out, prettyPrint);
    }

    public Object toObject(String json, Object hint) {
        if (hint instanceof Type) {
            return this.toObject(json, (Type)hint);
        }
        throw new IllegalArgumentException("hint is invalid.");
    }

    public Object toObject(String json, Type hint) {
        return JsonicMapper.decode(json, hint);
    }

    public String toJson(Object obj, boolean prettyPrint) {
        return JsonicMapper.encode(obj, prettyPrint);
    }

    public <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return JsonicMapper.decode(JsonicMapper.encode(fromValue), toValueType);
    }

    public Type convertValue(Object fromValue, Type toValueType) {
        return JsonicMapper.decode(JsonicMapper.encode(fromValue), toValueType);
    }

    public Map<String, Object> toMap(String json) {
        return (Map)JsonicMapper.decode(json);
    }

    public Map<String, Object> toMap(File in) {
        return (Map)JsonicMapper.decode(in);
    }

    public Map<String, Object> toMap(Reader in) {
        return (Map)JsonicMapper.decode(in);
    }

    public Map<String, Object> toMap(InputStream in) {
        return (Map)JsonicMapper.decode(in);
    }

    public List<Map<String, Object>> toList(File in) {
        return (List)JsonicMapper.decode(in);
    }

    public List<Map<String, Object>> toList(InputStream in) {
        return (List)JsonicMapper.decode(in);
    }

    public List<Map<String, Object>> toList(Reader in) {
        return (List)JsonicMapper.decode(in);
    }

    public List<Map<String, Object>> toList(String json) {
        return (List)JsonicMapper.decode(json);
    }

    private static <T> T decode(String source) {
        return (T)JSON.decode((String)source);
    }

    private static Type decode(String json, Type hint) {
        return (Type)JSON.decode((String)json, (Type)hint);
    }

    private static <T> T decode(String source, Class<T> clazz) {
        return (T)JSON.decode((String)source, clazz);
    }

    private static <T> T decode(File file) {
        return JsonicMapper.decode(FileUtils.newBufferedReader((Path)file.toPath()));
    }

    private static <T> T decode(InputStream in) {
        return JsonicMapper.decode(new InputStreamReader(in));
    }

    private static <T> T decode(Reader reader) {
        try {
            return (T)JSON.decode((Reader)reader);
        }
        catch (IOException | JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T decode(File file, Class<T> clazz) {
        return JsonicMapper.decode(FileUtils.newBufferedReader((Path)file.toPath()), clazz);
    }

    private static <T> T decode(InputStream in, Class<T> clazz) {
        return JsonicMapper.decode(new InputStreamReader(in), clazz);
    }

    private static <T> T decode(Reader reader, Class<T> clazz) {
        try {
            return (T)JSON.decode((Reader)reader, clazz);
        }
        catch (IOException | JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private static String encode(Object source) {
        return JsonicMapper.encode(source, false);
    }

    private static String encode(Object source, boolean prettyPrint) {
        try {
            return JSON.encode((Object)source, (boolean)prettyPrint);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private static void encode(Object source, File file, boolean prettyPrint) {
        JsonicMapper.encode(source, FileUtils.newBufferedWriter((Path)file.toPath(), (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[]{StandardOpenOption.CREATE}), prettyPrint);
    }

    private static void encode(Object source, OutputStream out, boolean prettyPrint) {
        JsonicMapper.encode(source, new OutputStreamWriter(out, StandardCharsets.UTF_8), prettyPrint);
    }

    private static void encode(Object source, Appendable appendable, boolean prettyPrint) {
        try {
            JSON.encode((Object)source, (Appendable)appendable, (boolean)prettyPrint);
        }
        catch (IOException | JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private static void format(int depth, Object res, Appendable ap) {
        try {
            new JSON(depth).format(res, ap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

