/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.h2;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.nkjmlab.sorm4j.sql.SelectSql;

public class H2SqlUtils {
    public static String getCsvReadSql(File fromFile, String fieldSeparator, List<String> colmuns) {
        return H2SqlUtils.getCsvReadSql(fromFile, StandardCharsets.UTF_8, fieldSeparator, colmuns);
    }

    public static String getCsvReadSql(File fromFile, Charset charset, String fieldSeparator, List<String> colmuns) {
        String csvOptions = "charset=" + charset.name() + " fieldSeparator=" + fieldSeparator;
        String csvStmt = "csvread(" + SelectSql.literal((Object)fromFile.getAbsolutePath()) + "," + (colmuns == null ? "null" : String.join((CharSequence)"|", colmuns)) + "," + SelectSql.literal((Object)csvOptions) + ")";
        return csvStmt;
    }

    public static String getCsvWriteSql(File toFile, Charset charset, String fieldSeparator, String selectSql) {
        String csvOptions = "charset=" + charset.name() + " fieldSeparator=" + fieldSeparator;
        String csvStmt = "csvwrite(" + SelectSql.literal((Object)toFile.getAbsolutePath()) + "," + SelectSql.literal((Object)selectSql) + "," + SelectSql.literal((Object)csvOptions) + ")";
        return csvStmt;
    }

    public static String getCsvWriteSql(File toFile, String fieldSeparator, String selectSql) {
        return H2SqlUtils.getCsvWriteSql(toFile, StandardCharsets.UTF_8, fieldSeparator, selectSql);
    }

    public static String getRenameTableSql(String fromTableName, String toTableName) {
        return "ALTER TABLE " + fromTableName + " RENAME TO " + toTableName;
    }

    public static String getCreateIndexOnSql(String tableName, String ... columns) {
        return "create index if not exists index_" + tableName + "_" + String.join((CharSequence)"_", columns) + " on " + tableName + "(" + String.join((CharSequence)", ", columns) + ")";
    }

    public static String dropTablesCascadeIfExist(String tableName) {
        return "DROP TABLE IF EXISTS " + tableName + " CASCADE";
    }
}

